package com.elitesland.tw.tw5.api.prd.file.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.file.payload.PrdFileRefPayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileRefQuery;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileRefVO;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;

import java.util.List;

/**
 * 附件 - 文件单据关联表
 *
 * @author duwh
 * @date 2022/09/23
 */
public interface PrdFileRefService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdFileRefVO}
     */
    PrdFileRefVO insert(PrdFileRefPayload payload);

    /**
     * 新增
     *
     * @param fileId       文件标识
     * @param docId        文档id
     * @param businessType 业务类型
     * @param docType      文档类型
     * @return {@link PrdFileRefVO}
     */
    PrdFileRefVO insert(Long fileId, Long docId, String businessType, String docType);

    /**
     * 列表文件
     *
     * @param docId        文档id
     * @param businessType 业务类型
     * @param docType      文档类型
     * @return {@link List}<{@link PrdFileVO}>
     */
    List<PrdFileVO> listFile(Long docId, String businessType, String docType);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdFileRefVO}
     */
    PrdFileRefVO update(PrdFileRefPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdFileRefVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link PrdFileRefVO}>
     */
    List<PrdFileRefVO> queryList(PrdFileRefQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdFileRefVO> paging(PrdFileRefQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
}
