package com.elitesland.tw.tw5.api.prd.org.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;

@Data
public class PrdOrgEmployeePayload extends TwCommonPayload {
    /**
     * 用户账号
     */
    @ApiModelProperty("用户账号")
    private String userName;
    /**
     * 用户姓氏
     */
    @ApiModelProperty("用户姓氏")
    private String lastName;
//    /**
//     * 用户名称
//     */
//    @ApiModelProperty("用户名称")
//    private String firstName;

    /**
     * 用户真实姓名
     */
    @ApiModelProperty("用户真实姓名")
    private String personName;
    /**
     * 用户电话
     */
    @ApiModelProperty("用户电话")
    private String mobile;
    /**
     * 用户邮箱
     */
    @ApiModelProperty("用户邮箱")
    private String email;
    /**
     * 账户状态
     */
    @ApiModelProperty("账户状态")
    private Boolean enabled = true;

    @ApiModelProperty("自然人ID")
    private Long personId;

    /**
     * 角色IDs 如果修改的时候传值是 “null”表示赋值角色没有改变，如果是空数组“[]”表示把赋值角色全部删除
     */
    private List<Long> roleIds;

    @ApiModelProperty("系统用户ID")
    private Long userId;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long companyId;
    /**
     * 员工编号
     */
    @ApiModelProperty("员工编号")
    private String employeeNo;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;
    /**
     * 员工名称
     */
    @ApiModelProperty("员工名称")
    private String employeeName;
    /**
     * 资源状态
     */
    @ApiModelProperty("资源状态")
    private String resourceStatus;
    /**
     * 人事状态
     */
    @ApiModelProperty("人事状态")
    private String hrStatus;//0：有效，1：无效
    /**
     * 入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;
    /**
     * 安全级别
     */
    @ApiModelProperty("安全级别")
    private Integer accessLevel;
    /**
     * 岗位
     */
    @ApiModelProperty("岗位")
    private String jobs;

    @ApiModelProperty("排序")
    private Integer sortIndex;

    /**
     * 外文名
     */
    @ApiModelProperty("外文名")
    private String foreignName;
    /**
     * 证件类型
     */
    @ApiModelProperty("证件类型")
    private String idType;

    /**
     * 证件号码
     */
    @ApiModelProperty("证件号码")
    private String idNo;
    /**
     * 证件开始日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;
    /**
     * 证件到期日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;
    /**
     * 证件url
     */
    @ApiModelProperty("证件url")
    private String idValidCodes;

    /**
     * 头像url
     */
    @ApiModelProperty("头像url")
    private String headCodes;

    /**
     * 生日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("生日")
    private LocalDate birthday;
    /**
     * 性别
     */
    @ApiModelProperty("性别")
    private String sex;

    /**
     * 国籍
     */
    @ApiModelProperty("国籍")
    private String nationality;
    /**
     * 籍贯
     */
    @ApiModelProperty("籍贯")
    private String birthplace;
    /**
     * 民族
     */
    @ApiModelProperty("民族")
    private String nation;
    /**
     * 婚姻状况 0:已婚，1：未婚
     */
    @ApiModelProperty("婚姻状况")
    private Integer marital = 1;
    /**
     * 通讯地址
     */
    @ApiModelProperty("通讯地址")
    private String addr;
    /**
     * 紧急联系人
     */
    @ApiModelProperty("紧急联系人")
    private String urgency_name;
    /**
     * 紧急联系人手机号
     */
    @ApiModelProperty("手机号")
    private String urgency_mobile;
    /**
     * 紧急联系人关系
     */
    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("上级编号")
    private String parentNo;

    /**
     * 专业级别
     */
    private String extString1;
    /**
     * 管理级别
     */
    private String extString2;
    /**
     * 专业序列
     */
    private String extString3;
    /**
     * 职位序列
     */
    private String extString4;
    /**
     * 主服务地址
     */
    private String extString5;
    /**
     * 内部类型：内部资源，外部资源
     */
    private String extString6;
    /**
     * 话费额度
     */
    private String extString7;
    /**
     * 电脑额度
     */
    private String extString8;
    /**
     * 资源类型2 正式员工，实行生等
     */
    private String extString9;
    private String extString10;
    private String extString11;
    private String extString12;
    /**
     * 离职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate1;
    /**
     * 转正日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate2;
    /**
     * 合同签订日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate3;
    /**
     * 合同到期日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate4;
    /**
     * 实习入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate5;
    /**
     * 试用期开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate6;
    /**
     * 试用期结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate7;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate8;

    /**
     * 组织id（新建员工初始默认组织使用）
     */
    @ApiModelProperty("组织ID")
    private Long orgId;
    /**
     * 上级员工id（新建员工初始默认组织使用）
     */
    @ApiModelProperty("上级员工ID")
    private Long parentId = 0L;

    /**
     * 修改类型
     */
    @ApiModelProperty("修改类型")
    private String subType;


    /**
     * 通过租户初始化数据   租户id
     */
    private Long initTenantId;
}
