package com.elitesland.tw.tw5.api.prd.schedule.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

/**
 * @author zoey
 * @Description:企业微信日程
 * @date 2022/4/19 - 14:36
 */
@Data
public class QyWxSchedulePayload extends TwCommonPayload {
    @ApiModelProperty("企业微信端主键")
    private String schedule_id;

    @ApiModelProperty("企业微信日历id")
    private String cal_id;

    @ApiModelProperty("组织者")
    private String organizer;

    @ApiModelProperty("日程标题")
    private String summary;

    @ApiModelProperty("日程描述")
    private String description;

    @ApiModelProperty("日程地址")
    private String location;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("开始时间")
    private Long start_time;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("结束时间")
    private Long end_time;

//    @ApiModelProperty("是否允许非参与人主动加入日程")
//    private Integer allowActiveJoin;

    @ApiModelProperty("不更新成员信息")
    private Boolean skip_attendees;

    @ApiModelProperty("日程参与成员")
    private List<QyWxScheduleAttendeesPayload> attendees;

    //这里企业微信将重复和提醒放在一起，对象名称叫reminders
    @ApiModelProperty("日程重复信息")
    private QyWxScheduleRepeatPayload reminders;


}
