package com.elitesland.tw.tw5.api.prd.schedule.sercvice;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdScheduleQuery;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/19 - 14:33
 */
public interface PrdScheduleService {

    PrdScheduleVO insertOrUpdate(PrdSchedulePayload payload);

    /*
     * @Author Zoey
     * @Description 将日程payload转为微信payload
     * @Date 17:40 2022/4/23
     **/
    QyWxSchedulePayload transferToQyWxPayload(PrdSchedulePayload schedulePayload);

    /*
     * @Author Zoey
     * @Description 将微信payload转为日程payload
     * @Date 17:40 2022/4/23
     **/
    PrdSchedulePayload transferToPrdPayload(QyWxSchedulePayload schedulePayload);

    List<PrdScheduleVO> queryList(PrdScheduleQuery query);

    void deleteSoft(List<Long> asList);


    PrdScheduleVO queryDetail(Long id);

    void deleteCurrent(Long id,String date);

    void deleteAfter(Long id,String date);

    void updateCurrent(PrdSchedulePayload payload);

    void updateAfter(PrdSchedulePayload payload);
}
