package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdFsmFileRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdFsmFileRefQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdFsmFileRefVO;

import java.util.List;

/**
 * 附件业务关系表
 *
 * @author duwh
 * @date 2022/11/22
 */
public interface PrdFsmFileRefService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdFsmFileRefVO}
     */
    PrdFsmFileRefVO insert(PrdFsmFileRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdFsmFileRefVO}
     */
    PrdFsmFileRefVO update(PrdFsmFileRefPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdFsmFileRefVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link PrdFsmFileRefVO}>
     */
    List<PrdFsmFileRefVO> queryList(PrdFsmFileRefQuery query);

    /**
     * 统计个数
     *
     * @param query 查询
     * @return long
     */
    long count(PrdFsmFileRefQuery query);

    /**
     * 统计个数
     *
     * @param objTypeEnum obj枚举类型
     * @param objId       obj id
     * @return long
     */
    long count(String objTypeEnum, Long objId);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdFsmFileRefVO> paging(PrdFsmFileRefQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 根据附件代码 逻辑删除
     *
     * @param fileCode 文件代码
     */
    void deleteSoftByFileCode(String fileCode);

    /**
     * 根据业务id和业务类型删除
     * @param objId
     * @param objType
     */
    void deleteSoftByObjIdAndObjType(Long objId, String objType);
}
