package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author carl.wang
 * @Description 市场计划明细表
 * @Date
 **/

@Data

public class CrmActPlanDetailPayload extends TwCommonPayload {

    /**
     * 计划id
     */
    private Long planId;

    /**
     * 活动类型
     */
    private String detailType;
    /**
     * 季节
     */
    private String detailSeason;
    /**
     * 项目名称
     */
    private String detailName;

    /**
     * 人力费用
     */
    private BigDecimal personMoney;

    /**
     * 人力资源
     */
    private String personSource;

    /**
     * 报销费用
     */
    private BigDecimal claimMoney;

    /**
     * 采购费用
     */
    private BigDecimal purchaseMoney;

    /**
     * 杂项费用
     */
    private BigDecimal sundryMoney;

    /**
     * 合计费用
     */
    private BigDecimal totalMoney;

    /**
     * 线索
     */
    private Integer leadNum;

    /**
     * pipeline
     */
    private BigDecimal pipeline;

    private BigDecimal extDecimal1;
    private BigDecimal extDecimal2;
    private String extString1;
    private String extString2;
    private String extString3;


    /**
     * 当前是否是在做市场计划变更
     */
    private Integer planChangeFlag;


    /**
     * 支出额
     */
    private BigDecimal expenditure;

}
