package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 市场活动汇报表
 * @Date
 **/

@Data

public class CrmActReportPayload extends TwCommonPayload {
    /**
     * 活动Id
     */
    private Long actId;
    /**
     * 累计投入人力总人天
     */
    private Integer personNum;
    /**
     * 累计投入人力费用
     */
    private BigDecimal personMoney;

    /**
     * 报销费用
     */
    private BigDecimal claimMoney;
    /**
     * 累计投入采购费用
     */
    private BigDecimal purchaseMoney;
    /**
     * 累计投入杂项费用
     */
    private BigDecimal sundryMoney;

    /**
     * 累计投入总额
     */
    private BigDecimal totalMoney;

    /**
     * 潜在客户
     */
    private Integer potentialCustomer;
    /**
     * 线索
     */
    private Integer leadNum;

    /**
     * 商机
     */
    private Integer busOps;
    /**
     * 产出预估总数
     */
    private BigDecimal pipeline;

    /**
     * 其他活动说明
     */
    private String reportContent;

    /**
     * 汇报类型1：详情汇报，2:结项报告
     */
    private Integer reportType = 1;//


    /**
     * 是否是更新操作
     */
    private Integer planChangeFlag;


    /**
     * 报告状态
     */
    private String reportStatus;

//    /**
//     * 流程提交标志
//     */
//    private Boolean submit;

    /**
     * 流程实例ID
     */
    private String procInstId;

    /**
     * 流程审批状态
     */
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;

}
