package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 人脉经营-经营机会点
 *
 * @author carl
 * @date 2022/11/21
 */
@Data
public class CrmCustomerOperationChanceVO extends BaseViewModel {
    /**
     * 人脉经营主键 crm_customer_operation.id
     */
    private Long operId;
    /**
     * 客户经营名称
     */
    private String custName;
    /**
     * 标题
     */
    private String title;

    /**
     * 跟踪人
     */
    private Long trackerUserId;
    /**
     * 跟踪人
     */
    private String trackerUserName;
    /**
     * 标签
     */
    private String tags;
    /**
     * 标签
     */
    private List<PrdSystemTagVO> tagsDesc;

    /**
     * 创建人
     */
    private String createUserName;
    /**
     * 是否已读
     */
    private Integer isRead;

    /**
     * 参与人
     */
    private String involvedUserIds;
    /**
     * 参与人
     */
    private List<Map<String, Object>> involvedUsers;
    /**
     * 知会人
     */
    private String informUserIds;
    /**
     * 知会人
     */
    private List<Map<String, Object>> informUsers;
    /**
     * 预计时间年份
     */
    private Integer expectYear;
    /**
     * 预计时间季度
     */
    private Integer expectQuarter;
    /**
     * 预计时间
     */
    private String expectTime;
    /**
     * 评论个数
     */
    private Long comments = 0L;

    /**
     * 附件个数
     */
    private Long files = 0L;

    /**
     * 详细描述
     */
    private String chanceContent;

    /**
     * 客户经营状态
     */
    private String custOperStatus;

    /**
     * 客户经营部门
     */
    private Long custOperBu;
    @UdcName(udcName = "BU", codePropName = "custOperBu")
    private String custOperBuName;

    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;
    @UdcName(udcName = "USER", codePropName = "custOperManagerId")
    private String custOperManagerName;

    /**
     * 销售经营部门
     */
    private Long saleOperBu;
    @UdcName(udcName = "BU", codePropName = "saleOperBu")
    private String saleOperBuName;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;
    @UdcName(udcName = "USER", codePropName = "saleOperManagerId")
    private String saleOperManagerName;

}
