package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author carl.wang
 * @Description:市场计划表
 * @date 2022/5/17 - 11:39
 */
@Data
public class CrmActPlanVO extends BaseViewModel {
    /**
     * 编号
     */
    private String planNo;
    /**
     * 名称
     */
    private String planName;
    /**
     * bu（组织）
     */
    private Long orgId;
    /**
     * 组织名称
     */
    private String orgName;
    /**
     * 预算年度
     */
    private String planYear;
    /**
     * 预算总金额
     */
    private BigDecimal budgetMoney;
    /**
     * 预估产出线索
     */
    private Integer leadNum;
    /**
     * 预估产出销售额
     */
    private BigDecimal pipeline;

    /**
     * 状态
     */
    private String planStatus;
    /**
     * 状态名称
     */
    private String planStatusName;
    /**
     * 流程实例ID
     */
    private String procInstId;
    /**
     * 申请人名称
     */
    private String createUserName;
    /**
     * 关闭或重新打开原因
     */
    private String operateReason;
    /**
     * 预算明细
     */
    private List<CrmActPlanDetailVO> planDetailVOS;


    /**
     * 流程审批状态
     */
    private ProcInstStatus procInstStatus;
    private String procInstStatusDesc;

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;
}
