package com.elitesland.tw.tw5.api.prd.crm.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 销售统计
 *
 * @author wangly
 * @date 2023-06-13
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class CrmSaleCountVO implements Serializable {

    /** 新增业务伙伴数量-客户身份 */
    @ApiModelProperty("新增业务伙伴数量-客户身份")
    private Long addBusinessCount;

    /** 新增线索数量 */
    @ApiModelProperty("新增线索数量")
    private Long addLeadsCount;

    /** 新增商机数量 */
    @ApiModelProperty("新增商机数量")
    private Long addOppoCount;

    /** 新增合同数量 */
    @ApiModelProperty("新增合同数量")
    private Long addContractCount;

    /** 新增拜访数量 */
    @ApiModelProperty("新增拜访数量")
    private Long addVisitCount;

    /** 商机金额 */
    @ApiModelProperty("商机金额")
    private BigDecimal oppoAmount;

    /** 合同金额 */
    @ApiModelProperty("合同金额")
    private BigDecimal contractAmount;

    /** 回款金额 */
    @ApiModelProperty("回款金额")
    private BigDecimal receiveAmount;
}
