package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemFunctionService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemFunctionVO insert(PrdSystemFunctionPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemFunctionPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemFunctionVO> paging(PrdSystemFunctionQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemFunctionVO queryByKey(Long key);

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 结果
     */
    List<PrdSystemFunctionVO> queryList(PrdSystemFunctionQuery query);

}
