package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionSpecialPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemFunctionSpecialService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemFunctionSpecialVO insert(PrdSystemFunctionSpecialPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemFunctionSpecialPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemFunctionSpecialVO> paging(PrdSystemFunctionSpecialQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemFunctionSpecialVO queryByKey(Long key);

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    List<PrdSystemFunctionSpecialVO> queryList(PrdSystemFunctionSpecialQuery query);
}
