package com.elitesland.tw.tw5.api.demo.student.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 学生 payload对象
 * @author zhangyongqiang
 */
@Data
public class DemoStudentPayload extends TwCommonPayload implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 学号
     */
    @ApiModelProperty("学号")
    private String studentNo;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    private String studentName;

    /**
     * 年龄
     */
    @ApiModelProperty("年龄")
    private Integer age;

    /**
     * 性别
     */
    @ApiModelProperty("性别")
    private String sex;

    /**
     * 生日
     */
    @ApiModelProperty("生日")
    private LocalDate birthday;

    /**
     * 班级Id
     */
    @ApiModelProperty("班级Id")
    private Long  classId;

    /**
     * 班级名称
     */
    @ApiModelProperty("班级名称")
    private String  className;


}
