package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * 客户经营-经营计划模板明细表
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanTempDetailQuery extends TwQueryParam {

    /**
     * 模板主表主键
     */
    @Query
    private Long tempId;

    /**
     * 计划名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String planName;

    /**
     * 计划内容
     */
    private String planContent;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    /**
     * 优先级 udc[crm:oper_plan:priority]
     */
    private String priority;

    /**
     * 状态 udc[crm:oper_plan:status]
     */
    private String status;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    public CrmOperationPlanTempDetailQuery() {
    }

    public CrmOperationPlanTempDetailQuery(Long tempId) {
        this.tempId = tempId;
    }
}
