package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreOptionListQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreOptionQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsOffshoreOptionVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author zoey
 * @Description:近海管理
 * @date 2022/5/20 - 16:20
 */
public interface CrmOffshoreService {
    CrmOffshoreVO saveOne(CrmOffshorePayload payload);

    List<CrmOffshoreListVO> queryList(CrmOffshoreQuery query);

    CrmOffshoreVO queryDetail(Long id);

    PagingVO paging(CrmOffshoreQuery query);

    void dynamicUpdate(CrmOffshorePayload payload);

    void downloadOffshores(HttpServletResponse response, CrmOffshoreQuery query);

    void importOffshores(MultipartFile file);

    /**
     * 近海查重分页
     *
     * @return result
     */
    PagingVO<CrmLeadsOffshoreOptionVO> checkRepeatPaging(CrmLeadsOffshoreOptionQuery query);

    /**
     * 近海查重详情分页
     *
     * @return result
     */
    PagingVO<CrmLeadsOffshoreOptionVO> checkRepeatDetailPaging(CrmLeadsOffshoreOptionListQuery query);
}
