package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author wangly
 * @Description:公海选项配置
 * @date 2023/06/12 - 11:38
 */
@Getter
@Setter
public class CrmOpenseaOptionVO extends BaseViewModel implements Serializable {


    /**
     * 重复数量
     **/
    @ApiModelProperty("重复数量")
    private Long count;

    /**
     * 潜在客户编号
     **/
    @ApiModelProperty("潜在客户编号")
    private String customerNo;

    /**
     * 客户名称
     **/
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 客户状态
     **/
    @ApiModelProperty("客户状态")
    private String customerStatus;

    /**
     * 客户状态描述
     **/
    @ApiModelProperty("客户状态描述")
    @UdcName(udcName = "crm:potential_customer_status",codePropName = "customerStatus")
    private String customerStatusDesc;

    /**
     * 客户地址-详细地址
     **/
    @ApiModelProperty("客户地址-详细地址")
    private String customerLocationDetail;

    /**
     * 市场活动id
     **/
    @ApiModelProperty("市场活动id")
    private Long marketId;

    /**
     * 市场活动
     **/
    @ApiModelProperty("市场活动")
    private String projectName;

    /**
     * 需求产品
     */
    @ApiModelProperty("需求产品")
    private String demandProduct;

    /**
     * 需求产品描述
     */
    @ApiModelProperty("需求产品描述")
    @UdcName(udcName = "crm:leads_demand_product",codePropName = "demandProduct")
    private String demandProductDesc;

    /**
     * 联系人姓名
     **/
    @ApiModelProperty("联系人姓名")
    private String customerContacts;

    /**
     * 联系人电话
     **/
    @ApiModelProperty("联系人电话")
    private String contactsPhone;

    /**
     * 客户邮箱
     **/
    @ApiModelProperty("邮箱")
    private String customerEmail;

    /**
     * 客户级别
     **/
    @ApiModelProperty("客户级别")
    private String customerGrade;

    /**
     * 客户级别描述
     **/
    @ApiModelProperty("客户级别描述")
    @UdcName(udcName = "crm:customer_grade",codePropName = "customerGrade")
    private String customerGradeDesc;

    /**
     * 所属公海
     **/
    @ApiModelProperty("所属公海")
    private String openseaName;

    /**
     * 公海配置项
     **/
    @ApiModelProperty("公海配置项")
    private String option;
}
