package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 客户经营-经营计划模板明细表
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanTempDetailVO extends BaseViewModel {

    /**
     * 模板主表主键
     */
    private Long tempId;

    /**
     * 计划名称
     */
    private String planName;

    /**
     * 计划内容
     */
    private String planContent;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 优先级 udc[crm:oper_plan:priority]
     */
    private String priority;
    @UdcName(udcName = "crm:oper_plan:priority", codePropName = "priority")
    private String priorityDesc;

    /**
     * 状态 udc[crm:oper_plan:status]
     */
    private String status;
    @UdcName(udcName = "crm:oper_plan:status", codePropName = "status")
    private String statusDesc;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

}
