package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitRuleVO;

import java.util.List;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
public interface AccReimSettingLimitRuleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingLimitRuleVO}>
     */
    PagingVO<AccReimSettingLimitRuleVO> queryPaging(AccReimSettingLimitRuleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingLimitRuleVO}>
     */
    List<AccReimSettingLimitRuleVO> queryListDynamic(AccReimSettingLimitRuleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingLimitRuleVO}
     */
    AccReimSettingLimitRuleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingLimitRuleVO}
     */
    AccReimSettingLimitRuleVO insert(AccReimSettingLimitRulePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingLimitRuleVO}
     */
    AccReimSettingLimitRuleVO update(AccReimSettingLimitRulePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingLimitRulePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
