package com.elitesland.tw.tw5.api.prd.budget.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

/**
 * 预算拨付基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetAppropriationQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 预算ID 精确 */
    @ApiModelProperty("预算ID")
    private Long budgetId;
    /** 拨付单号 精确 */
    @ApiModelProperty("拨付单号")
    private String appropriationNo;
    /** 拨付状态 精确 */
    @ApiModelProperty("拨付状态")
    private String appropriationStatus;
    /** 申请人资源ID 精确 */
    @ApiModelProperty("申请人资源ID")
    private Long resId;
    /** 申请费用金额 精确 */
    @ApiModelProperty("申请费用金额")
    private BigDecimal applyFeeAmt;
    /** 提现当量数 精确 */
    @ApiModelProperty("提现当量数")
    private BigDecimal applyEqva;
    /** 提现当量金额 精确 */
    @ApiModelProperty("提现当量金额")
    private BigDecimal applyEqvaAmt;
    /** 申请总金额 精确 */
    @ApiModelProperty("申请总金额")
    private BigDecimal applyAmt;
    /** 拨付金额 精确 */
    @ApiModelProperty("拨付金额")
    private BigDecimal amt;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private Integer procInstStatus;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /** 拨款名称 精确 */
    @ApiModelProperty("拨款名称")
    private String appropriationName;
    /** 拨款日期 精确 */
    @ApiModelProperty("拨款日期")
    private LocalDate appropriationDate;
    /** 拨付附件 精确 */
    @ApiModelProperty("拨付附件")
    private String appropriationFiles;
    /** 流程定义的KEY 精确 */
    @ApiModelProperty("流程定义的KEY")
    private String procDefKey;
    /** 拨付类型：科目、活动 精确 */
    @ApiModelProperty("拨付类型：科目、活动")
    private String appropriationType;
    /** 拨付当量 精确 */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;
    /** 拨付费用 精确 */
    @ApiModelProperty("拨付费用")
    private BigDecimal allocateCost;
}
