package com.elitesland.tw.tw5.api.prd.budget.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Getter
@Setter
public class PmsBudgetOccupyQuery extends TwQueryParam implements Serializable {
    /** 精确 */
    @ApiModelProperty("")
    private Long id;
    /** 预算id 精确 */
    @ApiModelProperty("预算id")
    private Long budgetId;
    /** 费用类型：当量｜费用 精确 */
    @ApiModelProperty("费用类型：当量｜费用")
    private String costType;
    /** 来源类型：任务｜报销 精确 */
    @ApiModelProperty("来源类型：任务｜报销")
    private String docType;
    /** 归属资源（当量预算|费用预算）id 精确 */
    @ApiModelProperty("归属资源（当量预算|费用预算）id")
    private Long belongToId;
    /** 单据id 精确 */
    @ApiModelProperty("单据id")
    private Long docId;
    /** 单据编号 模糊 */
    @ApiModelProperty("单据编号")
    private String docCode;
    /** 单据名称 模糊 */
    @ApiModelProperty("单据名称")
    private String docName;
}
