package com.elitesland.tw.tw5.api.prd.budget.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationDetailVO;

import java.util.List;

/**
 * 预算拨付明细
 *
 * @author xxb
 * @date 2023-11-01
 */
public interface BudgetAppropriationDetailService {

    /**
     * 批量保存
     *
     * @param appropriationId
     * @param list
     */
    void batchSave(Long appropriationId, List<BudgetAppropriationDetailPayload> list);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BudgetAppropriationDetailVO}>
     */
    PagingVO<BudgetAppropriationDetailVO> queryPaging(BudgetAppropriationDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BudgetAppropriationDetailVO}>
     */
    List<BudgetAppropriationDetailVO> queryListDynamic(BudgetAppropriationDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BudgetAppropriationDetailVO}
     */
    BudgetAppropriationDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BudgetAppropriationDetailVO}
     */
    BudgetAppropriationDetailVO insert(BudgetAppropriationDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BudgetAppropriationDetailVO}
     */
    BudgetAppropriationDetailVO update(BudgetAppropriationDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BudgetAppropriationDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据主键数据逻辑删除
     *
     * @param appId 主键
     */
    void deleteSoftByAppId(Long appId);

}
