package com.elitesland.tw.tw5.api.prd.budget.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 预算拨付基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetAppropriationVO extends BaseViewModel implements Serializable {
    /**
     * 预算ID
     */
    @ApiModelProperty("预算ID")
    private Long budgetId;
    /**
     * 拨付单号
     */
    @ApiModelProperty("拨付单号")
    private String appropriationNo;
    /**
     * 拨付状态
     */
    @ApiModelProperty("拨付状态")
    private String appropriationStatus;
    @UdcName(udcName = "budget:appropriationStatus", codePropName = "appropriationStatus")
    private String appropriationStatusDesc;
    /**
     * 申请人资源ID
     */
    @ApiModelProperty("申请人资源ID")
    private Long resId;
    /**
     * 申请费用金额
     */
    @ApiModelProperty("申请费用金额")
    private BigDecimal applyFeeAmt;
    /**
     * 提现当量数
     */
    @ApiModelProperty("提现当量数")
    private BigDecimal applyEqva;
    /**
     * 提现当量金额
     */
    @ApiModelProperty("提现当量金额")
    private BigDecimal applyEqvaAmt;
    /**
     * 申请总金额
     */
    @ApiModelProperty("申请总金额")
    private BigDecimal applyAmt;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private Integer procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 拨款名称
     */
    @ApiModelProperty("拨款名称")
    private String appropriationName;
    /**
     * 拨款日期
     */
    @ApiModelProperty("拨款日期")
    private LocalDate appropriationDate;
    /**
     * 拨付附件
     */
    @ApiModelProperty("拨付附件")
    private String appropriationFiles;
    /**
     * 流程定义的KEY
     */
    @ApiModelProperty("流程定义的KEY")
    private String procDefKey;
    /**
     * 拨付类型：科目、活动
     */
    @ApiModelProperty("拨付类型：科目、活动")
    private String appropriationType;
    /**
     * 拨付当量
     */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;
    /**
     * 拨付费用
     */
    @ApiModelProperty("拨付费用")
    private BigDecimal allocateCost;


    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    private String budgetCode;
    /**
     * 费用归属：合同项目、BU项目、商机项目
     */
    @ApiModelProperty("费用归属：合同项目、BU项目、商机项目")
    private String sourceType;
    /**
     * 费用归属ID
     */
    @ApiModelProperty("费用归属ID")
    private Long sourceId;
    /**
     * 费用归属名称
     */
    @ApiModelProperty("费用归属名称")
    private String sourceName;
    /**
     * 预算名称
     */
    @ApiModelProperty("预算名称")
    private String budgetName;


    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("平台合同类型")
    private String platType;
    @ApiModelProperty("工作类型")
    private String workType;

    @ApiModelProperty("活动明细")
    private List<PmsProjectActivityVO> activityVOS;

    /**
     * 拨付相关
     */
    @ApiModelProperty("已拨付费用金额")
    private BigDecimal allocatedAmt;
    @ApiModelProperty("已拨付当量数")
    private BigDecimal allocatedEqva;
    @ApiModelProperty("已拨付当量数金额")
    private BigDecimal allocatedEqvaAmt;
    @ApiModelProperty("已拨付总金额")
    private BigDecimal allocatedTotalAmt;
    @ApiModelProperty("剩余可拨付当量")
    private BigDecimal remainingEqva;
    @ApiModelProperty("剩余可拨付费用")
    private BigDecimal remainingAmt;
    @ApiModelProperty("累计拨付比例")
    private BigDecimal allocatedAppropriation;


    /**
     * 当量相关
     */
    @ApiModelProperty("规划当量数")
    private BigDecimal planEqva;
    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;


    /**
     * 费用相关
     */
    @ApiModelProperty("规划费用金额")
    private BigDecimal planAmt;
    @ApiModelProperty("占用费用金额")
    private BigDecimal occupyAmt;
    @ApiModelProperty("已使用费用金额")
    private BigDecimal usedAmt;


}
