package com.elitesland.tw.tw5.api.prd.budget.vo;

import com.alibaba.fastjson.JSON;
import org.mapstruct.Named;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Component
public class PmsBudgetOccupyDocInfoConvertor {
    /**
     * 对象转json字符串
     *
     * @param obj
     * @return
     */
    @Named("toJsonString")
    public String toJsonString(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        return JSON.toJSONString(obj);
    }

    /**
     * json字符串转对象
     *
     * @param jsonStr
     * @return
     */
    @Named("jsonStringToObject")
    public PmsBudgetOccupyDocInfo jsonStringToValueObject(String jsonStr) {
        if (!StringUtils.hasText(jsonStr)) {
            return null;
        }
        return JSON.parseObject(jsonStr, PmsBudgetOccupyDocInfo.class);
    }
}
