package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 任务包
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
public class CalTaskSettleDetailQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private List<Long> ids;
    /**
     * 结算单id 精确
     */
    @ApiModelProperty("结算单id")
    private Long settleId;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 任务id 精确
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    /**
     * 派发当量 精确
     */
    @ApiModelProperty("派发当量")
    private BigDecimal distedEqva;
    /**
     * 已结算当量 精确
     */
    @ApiModelProperty("已结算当量")
    private BigDecimal settledEqva;
    /**
     * 申请结算当量数 精确
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 快照完工百分比 精确
     */
    @ApiModelProperty("快照完工百分比")
    private BigDecimal ssCompPercent;
    /**
     * 申请结算百分比 精确
     */
    @ApiModelProperty("申请结算百分比")
    private BigDecimal applySettlePercent;
    /**
     * 申请结算总额 精确
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 实际结算当量数 精确
     */
    @ApiModelProperty("实际结算当量数")
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额 精确
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 结算说明 精确
     */
    @ApiModelProperty("结算说明")
    private String settleDesc;
}
