package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;

import java.util.List;

/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
public interface CalAccountService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalAccountVO}>
     */
    PagingVO<CalAccountVO> queryPaging(CalAccountQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalAccountVO}>
     */
    List<CalAccountVO> queryListDynamic(CalAccountQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalAccountVO}
     */
    CalAccountVO queryByKey(Long key);

    /**
     * 通过主键查询
     *
     * @param keys 主键
     * @return {@link CalAccountVO}
     */
    List<CalAccountVO> queryByKeys(List<Long> keys);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CalAccountVO}
     */
    CalAccountVO insert(CalAccountPayload payload);

//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link CalAccountVO}
//     */
//    CalAccountVO update(CalAccountPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CalAccountPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    //    /**
//     * 定时任务--年度账号数据清0
//     */
//    void initAccount();

    /**
     * 根据主题类型和主题id查询
     *
     * @param auType 主题类型
     * @param auId   主题id
     * @return 结果
     */
    CalAccountVO queryByAuTypeAndAuId(String auType, Long auId);

    /**
     * 根据主题类型和主题id查询
     *
     * @param auType 主题类型
     * @param auIds  主题id
     * @return 结果
     */
    List<CalAccountVO> queryByAuTypeAndAuIds(String auType, List<Long> auIds);

    /**
     * 根据主题类型和主题id查询
     *
     * @param auTypes 主题类型
     * @param auIds   主题id
     * @return 结果
     */
    List<CalAccountVO> queryByAuTypesAndAuIds(List<String> auTypes, List<Long> auIds);

    /**
     * 初始化历史账户
     */
    void initAccount();

    /**
     * 账户关闭
     *
     * @param key
     */
    void closeAccount(Long key);


}
