package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOppoConversionRatePayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoConversionRateVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoDataSourceFieldsVO;

import java.util.List;


/**
 * 商机成单率配置
 * @author likunpeng
 * @date 2023/11/3
 */
public interface CrmOppoConversionRateService {

    /**
     * 商机成单率配置-新增或修改
     * @param payload 有效载荷
     * @return CrmOppoConversionRateVO
     */
    CrmOppoConversionRateVO insertOrUpdate(CrmOppoConversionRatePayload payload);

    /**
     * 商机成单率配置-查看
     * @return CrmOppoConversionRateVO
     */
    CrmOppoConversionRateVO queryConfig();

    /**
     * 商机成单率配置-数据源字段列表
     * @return 结果
     */
    List<CrmOppoDataSourceFieldsVO> queryDataSourceFields();

    /**
     * 根据id查询配置
     * @param fieldId
     * @return
     */
    CrmOppoDataSourceFieldsVO queryDataSourceFieldsById(Long fieldId);

}
