package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/
@Data
public class CrmOpportunityListVO extends BaseViewModel {
    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 项目名称（名称）
     */
    private String projectName;

    /**
     * 项目编号（活动编号）
     */
    private String projectNo;

    private Long oppoIdV4;

    /**
     * 项目状态
     */
    private String projectStatus;
    /**
     * 签单bu
     */
    private Long orgId;
    /**
     * 签单负责人
     */
    private Long manageUserId;
    /**
     * 售前bu
     */
    private Long preSaleOrgId;

    /**
     * 交付bu
     */
    private Long deliOrgId;
    /**
     * 交付bu
     */
    private Long deliUserId;
    /**
     * 售前bu
     */
    @UdcName(udcName = "BU", codePropName = "preSaleOrgId")
    private String preSaleOrgName;
    /**
     * 售前负责人
     */
    private Long preSaleUserId;
    @UdcName(udcName = "USER", codePropName = "preSaleUserId")
    private String preSaleUserName;
    /**
     * 客户id 老客户才会选择
     */
    private Long custBookId;
    /**
     * 客户名称（如果custBookId非空，要取对应的客户名称）
     */
    private String custBookName;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;

    @ApiModelProperty("预计签单金额")
    private BigDecimal forecastAmount;
}
