package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityStructPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityStructQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityStructVO;


import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力构成Service
 */
 
public interface PrdCompositeAbilityStructService {
    
    /**
     * 新增复合能力构成数据
     * @param prdCompositeAbilityStructPayload
     * @return
     */
    PrdCompositeAbilityStructVO save(PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload);
    
     /**
     * 根据主键更新
     * @param prdCompositeAbilityStructPayload
     * @return
     */
    PrdCompositeAbilityStructVO update(PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdCompositeAbilityStructVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdCompositeAbilityStructQuery
     * @return
     */
    PagingVO<PrdCompositeAbilityStructVO> page(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdCompositeAbilityStructQuery
      * @return
      */
     List<PrdCompositeAbilityStructVO> getList(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery);

     /**
      * 根据能力id删除
      * @param id
      * @return
      */
     Long delByAbilitId(Long id);
 }

