package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Data
public class TimesheetPayload extends TwCommonPayload {

    /**
     * 是否提交操作  默认否
     */
    private boolean submitted = false;
    /**
     * 填报用户id
     */
    private Long tsUserId;
    /**
     * 填报Bu主键
     */
    private Long tsUserBuId;
    /**
     * 填报Bu名称
     */
    private String tsUserBuName;
    /**
     * 状态 see TimesheetStatus
     */
    private String tsStatus;
    /**
     * 类型
     */
    private String type;
    /**
     * 审批用户id
     */
    private Long apprUserId;
    /**
     * 客户经营计划主键
     */
    private Long operPlanId;
    /**
     * 客户经营计划名称冗余
     */
    private String operPlanName;
    /**
     * 项目id
     */
    private Long projId;
    /**
     * 项目编号冗余
     */
    private String projNo;
    /**
     * 项目名称
     */
    private String projName;
    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 PROJ_CONTRACT 合同项目 PROJ_OPPO 售前商机项目 PROJ_BU bu项目")
    private String reasonType;


    /**
     * 项目阶段id（活动阶段）
     */
    private Long stageId;
    /**
     * 项目阶段编号（冗余）
     */
    private String stageNo;
    /**
     * 项目阶段名称冗余
     */
    private String stageName;

    /**
     * tm类型 区分 本地现场80，出差100，本地延迟0
     */
    private String tmType;
    /**
     * 任务包id
     */
    private Long taskPackageId;
    /**
     * 任务包编号 冗余
     */
    private String taskPackageNo;
    /**
     * 任务包名称冗余
     */
    private String taskPackageName;

    /**
     * 任务id  4.0任务主键
     */
    private Long taskId;

    /**
     * 设置任务id
     *
     * pc端 无任务的时候传0 ，数据不需要；
     * app端 无任务的时候未传此值
     *
     * @param taskId 任务id
     */


    /**
     * 任务编号冗余
     */
    private String taskNo;
    /**
     * 任务名称冗余
     */
    private String taskName;
    /**
     * 任务包申请状态
     */
    private String taskApplyStatus;
    /**
     * 活动id
     */
    private Long actId;
    /**
     * 活动名称冗余
     */
    private String actName;
    /**
     * 活动编号冗余
     */
    private String actNo;

    /**
     * 当量
     */
    private BigDecimal eqva;
    /**
     * 11上午、22下午、33全天、44自定义
     */
    private String workType;
    /**
     * 工作日期
     */
    private LocalDate workDate;
    /**
     * 工时
     */
    private BigDecimal workHour;

    public Double getDoubleWorkHour() {
        if (workHour == null) {
            return BigDecimal.ZERO.doubleValue();
        }
        return workHour.doubleValue();
    }

    /**
     * 工作说明
     */
    private String workDesc;
    /**
     * 本周开始日期
     */
    private LocalDate weekStartDate;
    /**
     * 所在年周
     */
    private Integer yearWeek;
    /**
     * 总计人天
     */
    private BigDecimal totalManday;
    /**
     * 总计小时数
     */
    private BigDecimal totalWorkHour;
    /**
     * 审批状态
     */
    private String apprStatus;
    /**
     * 任务标识
     */
    private String tsTaskIden;
    /**
     * 活动标识
     */
    private String tsActIden;
    /**
     * 结算状态
     */
    private String settleStatus;
    /**
     * 审批状态
     */
    private String apprResult;
    /**
     * 是否加班、udc >> yesno
     */
    private String workFlag;
    /**
     * 可生成调休天数
     */
    private Float workDayOff;
    /**
     * 相关加班安排id
     */
    private Integer workRelId;
    /**
     * 可生成调休天数的状态
     */
    private String workDayOffStatus;
    /**
     * 工作计划id
     */
    private Long workPlanId;
    /**
     * 审批时间
     */
    private LocalDateTime approvalTime;
    /**
     * 提交时间
     */
    private LocalDateTime submitTime;
    /**
     * 最后提交时间
     */
    private LocalDateTime lastSubmitTime;
    /**
     * 是否是系统自动生成，0：否，1：是
     */
    private Integer autoSaveFlag;
    /**
     * 请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1
     */
    private Integer autoUpdateFlag;
    /**
     * 流程实例id
     */
    private String procId;
    /**
     * 拓展1
     */
    private String ext1;
    /**
     * 拓展2
     */
    private String ext2;
    /**
     * 拓展3
     */
    private String ext3;
    /**
     * 拓展4
     */
    private String ext4;
    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 帮我吧工时
     */
    private BigDecimal bangwo8WorkHour;

    /**
     * 帮我吧工单链接
     */
    private String ticketUrl;

    /**
     * 帮我吧工时唯一标识
     */
    private Long bangwo8No;


    /**
     * 地址
     */
    private String location;


    /**
     * 请假申请明细id
     */
    private Long vacationApplyDetailId;

    /**
     * UT值
     */
    private Integer ut;

    @ApiModelProperty("是否可退回标记")
    private Boolean returnFlag;
}
