package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSyncDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsTimesheetProjectVO;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
public interface PmsTimesheetService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    PagingVO<TimesheetVO> paging(TimesheetQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    PagingVO<TimesheetVO> pagingPermission(TimesheetQuery query);

    /**
     * 工时详细审批
     *
     * @param query
     * @return
     */
    PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query);

    /**
     * 分组审批分页列表
     *
     * @param query 查询
     * @return {@link PagingVO}
     */
    PagingVO pagingGroup(TimesheetQuery query);

    /**
     * 分组审批列表
     *
     * @param query 查询
     * @return {@link List}<{@link TimesheetVO}>
     */
    List<TimesheetVO> listGroup(TimesheetQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetVO}>
     */
    List<TimesheetVO> queryList(TimesheetQuery query);

    List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query);

    /**
     * 统计
     *
     * @param query 查询
     * @return long
     */
    long count(TimesheetQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetVO}
     */
    TimesheetVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TimesheetVO}
     */
    TimesheetVO insert(TimesheetPayload payload);

    /**
     * 批量新增
     *
     * @param payloadList 有效载荷列表
     * @return {@link List}<{@link TimesheetVO}>
     */
    void saveAllForAutoCreate(List<TimesheetPayload> payloadList);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TimesheetVO}
     */
    TimesheetVO update(TimesheetPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 撤销
     *
     * @param keys 键
     */
    void revoked(List<Long> keys);


    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetVO}>
     */
    List<TimesheetVO> batchInsert(TimesheetListPayload payload);

    /**
     * 审批通过
     *
     * @param keys 键
     */
    void toApproved(List<Long> keys);

    /**
     * 高级审批
     *
     * @param keys 键
     */
    void toAdvanced(List<Long> keys);

    /**
     * 审批拒绝
     *
     * @param keys       键
     * @param apprResult 审批结果
     */
    void rejected(List<Long> keys, String apprResult);

    /**
     * 更新任务包工时当量信息
     *
     * @param taskIdSet 任务id集合
     */
    void updateTaskTimesheetEqva(List<Long> taskIdSet);

    /**
     * 查询工时与与之对应的关系
     *
     * @return
     */
    Map<Long, Long> getTimesheetAndPlanIds();

    /**
     * 查询工时4.0与5.0的关系
     *
     * @return
     */
    Map<Long, Long> getV4AndV5TimesheetIds();

    /**
     * 月度工时概览
     *
     * @param query
     * @return
     */
    Map<LocalDate, Object> getTimesheetOverview(TimesheetQuery query);

    /**
     * 月度工时概览
     *
     * @param query
     * @return
     */
    Boolean getTimesheetRemind(TimesheetQuery query);


    /**
     * 差旅报销-月度工时概览
     *
     * @param query
     * @return
     */
    Map<LocalDate, Object> getAccReimTimesheetOverview(TimesheetQuery query);


    /**
     * 工时列表变更审批人
     *
     * @param keys
     * @param apprUserId
     */
    void updateApprovingUser(List<Long> keys, Long apprUserId);


    /**
     * 生成法定假日工时
     *
     * @param param
     */
    void generateVacationPublicTimesheet(String param);

    /**
     * 工时填写企业微信自动提醒(BU/研发BU全员)
     */
    String timesheetAlertAll();

    /**
     * 工时填写企业微信自动提醒(上级)
     */
    String timesheetAlertSuperior();

    /**
     * 工时填写企业微信自动提醒(BU领导提醒)
     */
    String timesheetAlertBuLeader();

    /**
     * 工时填写的修改
     */
    void repairTimesheet();

    String timesheetApprovingAlert();

    /**
     * 批准撤销
     *
     * @param list 列表
     */
    void approvedRevoked(List<Long> list);

    /**
     * 生成工时
     *
     * @param applyPayload
     */
    void generateVacationPrivateTimesheet(UserVacationApplyPayload applyPayload);

    /**
     * 删除工时
     *
     * @param applyDetailIds
     */
    void deleteVacationPrivateTimesheet(List<Long> applyDetailIds);

    /**
     * 更新状态
     *
     * @param applyPayload
     * @param opertType    0 删除工时，1审批通过工时
     */
    void updateVacationPrivateTimesheet(UserVacationApplyPayload applyPayload, Integer opertType);

    /**
     * 工时列表权限
     *
     * @param query
     */
    void getPermissionParams(TimesheetQuery query);

    /**
     * 月度员工工时统计
     *
     * @param query 查询条件
     * @return 员工月度工时统计VO
     */
    PagingVO monthlyPaging(MonthlyTimesheetQuery query);

    /**
     * 月度员工工时导出同步至JDE【上传文件】
     *
     * @param query 查询条件
     * @return result
     */
    void monthlySyncToJDE(MonthlyTimesheetQuery query);

    /**
     * 月度员工工时导出
     *
     * @param query    查询条件
     * @param response 响应
     */
    void monthlyExport(MonthlyTimesheetQuery query, HttpServletResponse response);

    /**
     * 通过dao层查询
     *
     * @param query
     * @return
     */
    List<TimesheetVO> queryDaoList(TimesheetQuery query);

    List<PmsTimesheetProjectVO> listProject(Long userId, Boolean selectAll);
}
