package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Getter
@Setter
public class PmsProjectActivityPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 活动编号
     */
    @ApiModelProperty("活动编号")
    private String actNo;
    /**
     * 活动名称
     */
    @ApiModelProperty("活动名称")
    private String actName;
    /**
     * 是否里程碑标志
     */
    @ApiModelProperty("是否里程碑标志")
    private Integer milestoneFlag;
    /**
     * 是否阶段标志
     */
    @ApiModelProperty("是否阶段标志")
    private Integer phaseFlag;
    /**
     * 是否来自模板标志
     */
    @ApiModelProperty("是否来自模板标志")
    private Integer fromtmplFlag;
    /**
     * 起日期
     */
    @ApiModelProperty("起日期")
    private LocalDate startDate;
    /**
     * 止日期
     */
    @ApiModelProperty("止日期")
    private LocalDate endDate;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 工作台显示标志
     */
    @ApiModelProperty("工作台显示标志")
    private Integer workbenchFlag;
    /**
     * 收款计划ID
     */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;

    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;

    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;

    /**
     * 拨付状态
     */
    @ApiModelProperty("拨付状态")
    private String allocateStatus;

    /**
     * 拨付当量
     */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;

    /**
     * 拨款金额
     */
    @ApiModelProperty("拨款金额")
    private BigDecimal allocateCost;

    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag;


    @ApiModelProperty("变更备注")
    private String changeRemark;

    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;

    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;


    @ApiModelProperty("使用费用占比")
    private BigDecimal usedAmtProportion;
}
