package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * BU项目管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Getter
@Setter
public class BuProjectQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * BU_ID 精确
     */
    @ApiModelProperty("BU_ID")
    private Long buId;
    /**
     * 科目模板id 精确
     */
    @ApiModelProperty("科目模板id")
    private Integer projYear;
    /**
     * 项目编号 模糊
     */
    @ApiModelProperty("项目编号")
    private String projNo;
    /**
     * 项目名称 模糊
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 项目状态 精确
     */
    @ApiModelProperty("项目状态")
    private String projStatus;
    /**
     * 项目模板id 精确
     */
    @ApiModelProperty("项目模板id")
    private String projTempId;
    /**
     * 科目模板id 精确
     */
    @ApiModelProperty("科目模板id")
    private Long subjectTempId;
    /**
     * 预计开始日期 精确
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期 精确
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 项目经理资源id 精确
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    /**
     * 项目经理当量系数 精确
     */
    @ApiModelProperty("项目经理当量系数")
    private BigDecimal pmEqvaRatio;
    /**
     * 主交付BU_ID 精确
     */
    @ApiModelProperty("主交付BU_ID")
    private Long deliBuId;
    /**
     * 交付用户id 精确
     */
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    /**
     * 预算总人天 精确
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 总当量 精确
     */
    @ApiModelProperty("总当量")
    private BigDecimal totalEqva;
    /**
     * 费用总预算 精确
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价 精确
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 费用总成本（当量成本+费用总预算） 精确
     */
    @ApiModelProperty("费用总成本（当量成本+费用总预算）")
    private BigDecimal totalCost;
    /**
     * 关闭原因 精确
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 项目进度状态 精确
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;
    /**
     * 自动汇报标识 精确
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;
    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4 精确
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5 精确
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = false;
}
