package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityProcessVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
public interface PmsProjectActivityService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectActivityVO}>
     */
    PagingVO<PmsProjectActivityVO> queryPaging(PmsProjectActivityQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectActivityVO}>
     */
    List<PmsProjectActivityVO> queryListDynamic(PmsProjectActivityQuery query);
    List<PmsProjectActivityVO> listForTimesheet(PmsProjectActivityQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectActivityVO}>
     */
    long countListDynamic(PmsProjectActivityQuery query);


    /**
     * 获取已经激活的 活动
     *
     * @param projId
     * @param phaseFlag
     * @return
     */
    List<PmsProjectActivityVO> queryActiveList(Long projId, int phaseFlag);

    /**
     * 简单查询已经激活的 活动
     *
     * @param projId
     * @return
     */
    List<PmsProjectActivityVO> querySimpleActiveList(Long projId);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectActivityVO}
     */
    PmsProjectActivityVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectActivityVO}
     */
    PmsProjectActivityVO insert(PmsProjectActivityPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectActivityVO}
     */
    PmsProjectActivityVO update(PmsProjectActivityPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectActivityPayload payload);

    /**
     * 批量更新  -- 用于序号批量更新
     *
     * @param payloads
     */
    void batchUpdateSortNo(List<PmsProjectActivityPayload> payloads);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 提交
     *
     * @param projId
     */
    void submit(Long projId);

    String getActivityStatus(Long projId);

    /**
     * 项目活动流程-主键查询
     *
     * @param activityProcessID
     * @return
     */
    PmsProjectActivityProcessVO byActivityProcessID(Long activityProcessID);

    /**
     * 导入活动文件
     *
     * @param file 请求响应
     */
    void importFile(MultipartFile file, Long projId);

    /**
     * 活动管理模板导出
     *
     * @param response
     */
    void downloadFile(HttpServletResponse response);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 任务创建回调
     *
     * @param payload
     */
    void taskCreated(TaskCreatedPayload payload);

    /**
     * 更新 活动拨付相关信息
     *
     * @param activityId
     * @param allocateEqva
     * @param allocateCost
     * @param allocateStatus
     */
    void updateAllocate(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus);

    /**
     * 更新 活动的  规划当量
     *
     * @param activityPayloads
     */
    void batchUpdate(List<PmsProjectActivityPayload> activityPayloads);

    /**
     * 更新拨付状态
     */
    void updateAllocateStatus(List<Long> activityIds, String status);
}
