package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;


/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Getter
@Setter
public class PmsProjectActivityVO extends BaseViewModel implements Serializable {
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 活动编号
     */
    @ApiModelProperty("活动编号")
    private String actNo;
    /**
     * 活动名称
     */
    @ApiModelProperty("活动名称")
    private String actName;
    /**
     * 是否里程碑标志
     */
    @ApiModelProperty("是否里程碑标志")
    private Integer milestoneFlag;
    /**
     * 是否阶段标志
     */
    @ApiModelProperty("是否阶段标志")
    private Integer phaseFlag;
    /**
     * 是否来自模板标志
     */
    @ApiModelProperty("是否来自模板标志")
    private Integer fromtmplFlag;
    /**
     * 起日期
     */
    @ApiModelProperty("起日期")
    private LocalDate startDate;
    /**
     * 止日期
     */
    @ApiModelProperty("止日期")
    private LocalDate endDate;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 工作台显示标志
     */
    @ApiModelProperty("工作台显示标志")
    private Integer workbenchFlag;
    /**
     * 收款计划ID
     */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;


    /**
     * 收款计划阶段描述
     */
    @ApiModelProperty("收款计划阶段描述")
    private String receivePlanDesc;

    /**
     * 拨付状态
     */
    @ApiModelProperty("拨付状态")
    private String allocateStatus;

    /**
     * 拨付状态
     */
    @ApiModelProperty("项目活动拨付状态")
    private String allocateStatusDesc;

    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;

    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;


    @ApiModelProperty("已派发当量")
    private BigDecimal distedEqva;


    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;

    /**
     * 当期收款比例
     */
    @ApiModelProperty("当期收款比例")
    private BigDecimal receRatio;

    /**
     * 当期收款金额
     */
    @ApiModelProperty("当期收款金额")
    private BigDecimal receAmt;

    /**
     * 收款状态
     */
    @ApiModelProperty("收款状态")
    private String receStatus;
    @ExcelProperty(index = 6, value = "收款状态")
    private String receStatusDesc;

    /**
     * 预计收款日期
     */
    @ApiModelProperty("预计收款日期")
    private LocalDate expectReceDate;

    /**
     * 预计收款日期
     */
    @ApiModelProperty("判断收款的预计收款日期在不在阶段的起止日期内 1在 0不在")
    private int expectReceDateFlag;


    @ApiModelProperty("拨付费用")
    private BigDecimal allocateCost;

    @ApiModelProperty("版本变更值相关")
    private Map<String, BigDecimal> changeInfo;


    @ApiModelProperty("变更前")
    private BigDecimal beforeValue;
    @ApiModelProperty("差异")
    private BigDecimal deltaValue;
    @ApiModelProperty("变更后")
    private BigDecimal afterValue;

    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag;

    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;
    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;


    @ApiModelProperty("变更备注")
    private String changeRemark;
}
