package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
 * 资源规划
 *
 * @author xxb
 * @date 2023-08-11
 */
@Getter
@Setter
public class PmsResourcePlanVO extends BaseViewModel implements Serializable {
    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型")
    private String planType;
    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型")
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "sourceType")
    private String planTypeDesc;
    /**
     * 关联对象ID
     */
    @ApiModelProperty("关联对象ID")
    private Long objId;
    /**
     * 关联对象
     */
    @ApiModelProperty("关联对象")
    private String objName;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 持续时长
     */
    @ApiModelProperty("持续时长")
    private Integer duration;
    /**
     * 资源规划状态 0正常
     */
    @ApiModelProperty("资源规划状态 0正常")
    private String planningStatus;

    @ApiModelProperty("资源规划状态 0正常")
    private String planningStatusDesc;

    @ApiModelProperty("资源规划周期: WEEK周 MONTH月")
    private String resourcePlanningCycle;

    @ApiModelProperty("资源规划明细")
    private List<PmsResourcePlanRoleVO> resourcePlanRoleVOS;

    /** 以下是预留字段 */

//    /** 商机销售阶段  --- 给商机类型资源规划用的 */
//    @ApiModelProperty("商机销售阶段  --- 给商机类型资源规划用的")
//    private String salePhase;
//    /** 成单概率交付角度 --- 给商机类型资源规划用的 */
//    @ApiModelProperty("成单概率交付角度 --- 给商机类型资源规划用的")
//    private String probability;
//    /** 版本号  */
//    @ApiModelProperty("版本号 ")
//    private String versionNo;
//    /** 变更原因 */
//    @ApiModelProperty("变更原因")
//    private String changeReason;
//    /** 交付负责人 */
//    @ApiModelProperty("交付负责人")
//    private Long deliResId;
//    /** BUID */
//    @ApiModelProperty("BUID")
//    private Long buId;
}
