package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 逾期付款计划
 *
 * @author likunpeng
 * @date 2023-11-24
 */
@Getter
@Setter
public class LatePaymentPlanVO extends BaseViewModel implements Serializable {

    /** 采购合同ID*/
    @ApiModelProperty("采购合同ID")
    private Long purchaseConId;

    /** 采购合同编号 */
    @ApiModelProperty("采购合同编号")
    private String purchaseConNo;

    /** 采购合同名称 */
    @ApiModelProperty("采购合同名称")
    private String purchaseConName;

    /** 供应商BookId */
    @ApiModelProperty("供应商BookId")
    private Long supplierBookId;

    /** 供应商名称 */
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /** 采购负责人 */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;
    @UdcName(udcName = "USER", codePropName = "purchaseInchargeResId")
    private String purchaseInchargeResName;

    /** 付款阶段 */
    @ApiModelProperty("付款阶段")
    private String paymentStage;

    /** 付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currentPaymentAmt;

    /** 付款比例 */
    @ApiModelProperty("付款比例")
    private BigDecimal paymentProportion;

    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    private LocalDate estimatedPaymentDate;

    /** 备注 */
    @ApiModelProperty("备注")
    private String remark;

    /** 合同节点状态（合同收款计划表状态）*/
    @ApiModelProperty("合同节点状态")
    private String receivableStatus;
    @UdcName(udcName = "salecon:payment_status", codePropName = "receivableStatus")
    private String receivableStatusDesc;

    /** 已收款金额 */
    @ApiModelProperty("已收款金额")
    private BigDecimal actualRecvAmt;

    /** 约束里程碑 */
    @ApiModelProperty("约束里程碑")
    private String milestoneName;


}
