package com.elitesland.tw.tw5.api.prd.purchase.vo;

import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVerDetailVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 付款申请单
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@SearchBean(
        tables = "t_purchase_payment pay "
//                +
//                "left join prj_project prj on pay.opportunity = prj.project_no " +
//                "left join acc_financial_subject acc on pay.accounting_subject = acc.id "
        ,
        where = "pay.delete_flag = 0",
        autoMapTo = "pay"
)
@Getter
@Setter
public class PurchasePaymentVO extends BaseViewModel implements Serializable {
    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单编号")
    private String paymentNo;
    /**
     * 付款申请单类型
     */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;
    @UdcName(udcName = "purchase:payment_type", codePropName = "paymentApplicationType")
    @DbIgnore
    private String paymentApplicationTypeDesc;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applicationDate;
    /**
     * 供应商地址薄Id
     */
    @ApiModelProperty("供应商地址薄Id")
    private Long supplierLegalBookId;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @DbIgnore
    private String supplierLegalName;
    /**
     * 验收方式
     */
    @ApiModelProperty("验收方式")
    private String acceptanceType;
    @ApiModelProperty("验收方式Desc")
    @UdcName(udcName = "purchase:check", codePropName = "acceptanceType")
    @DbIgnore
    private String acceptanceTypeDesc;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;
    /**
     * 本次付款金额
     */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currPaymentAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种Desc")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    @DbIgnore
    private String currCodeDesc;
    /**
     * 付款申请人
     */
    @ApiModelProperty("付款申请人")
    private Long purchaseInchargeResId;
    @UdcName(udcName = "USER", codePropName = "purchaseInchargeResId")
    @DbIgnore
    private String purchaseInchargeResName;
    /**
     * 付款申请单名称
     */
    @ApiModelProperty("付款申请单名称")
    private String purchaseName;
    /**
     * 发票核销状态
     */
    @ApiModelProperty("发票核销状态")
    private String invoiceState;
    @ApiModelProperty("发票核销状态Desc")
    @UdcName(udcName = "inv:invoice_state", codePropName = "invoiceState")
    @DbIgnore
    private String invoiceStateDesc;
    /**
     * 需求编号
     */
    @ApiModelProperty("需求编号")
    private String demandNo;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String docType;
    @ApiModelProperty("关联单据类型Desc")
    @UdcName(udcName = "purchase:doc_type", codePropName = "docType")
    @DbIgnore
    private String docTypeDesc;
    /**
     * 关联单据号
     */
    @ApiModelProperty("关联单据号")
    private String docNo;
    /**
     * 关联单据Id
     */
    @ApiModelProperty("关联单据Id")
    @DbIgnore
    private Long docId;
    /**
     * 关联销售合同编号
     */
    @ApiModelProperty("关联销售合同编号")
    private String relatedSalesContract;
    /**
     * 关联销售合同Id
     */
    @ApiModelProperty("关联销售合同Id")
    @DbIgnore
    private Long relatedSalesContractId;
    /**
     * 关联项目号
     */
    @ApiModelProperty("关联项目号")
    private String relatedProjectNo;
    /**
     * 关联项目号Id
     */
    @ApiModelProperty("关联项目号Id")
    @DbIgnore
    private Long relatedProjectId;
    /**
     * 付款依据
     */
    @ApiModelProperty("付款依据")
    private String basisFileCodes;
    /**
     * 付款依据附件数据
     */
    @ApiModelProperty("付款依据附件数据")
    @DbIgnore
    private Object basisFileDates;
    /**
     * 紧急付款凭证
     */
    @ApiModelProperty("紧急付款凭证")
    private String urgentPaymentCodes;
    /**
     * 紧急付款凭证附件数据
     */
    @ApiModelProperty("紧急付款凭证附件数据")
    @DbIgnore
    private Object urgentPaymentDates;
    /**
     * 归属付款申请
     */
    @ApiModelProperty("归属付款申请")
    private String attributionPayApply;
    /**
     * 发票编号
     */
    @ApiModelProperty("发票编号")
    private String invoiceNo;
    /**
     * 发票金额
     */
    @ApiModelProperty("发票金额")
    private BigDecimal invoiceAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String rate;
    @ApiModelProperty("税率Desc")
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "rate")
    @DbIgnore
    private String rateDesc;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmount;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String payMethod;
    @ApiModelProperty("付款方式Desc")
    @UdcName(udcName = "ACC:PAY_METHOD", codePropName = "payMethod")
    @DbIgnore
    private String payMethodDesc;

    /**
     * 付款日期
     */
    @ApiModelProperty("付款日期")
    private LocalDate payDate;
    /**
     * 付款账期(天)
     */
    @ApiModelProperty("付款账期(天)")
    private Integer relatedDays;
    /**
     * 付款账期到期时间
     */
    @ApiModelProperty("付款账期到期时间")
    private LocalDateTime expRelatedDate;
    /**
     * 收款人/单位BookId
     */
    @ApiModelProperty("收款人/单位BookId")
    private Long receivingUnitBookId;
    @ApiModelProperty("收款人/单位")
    @DbIgnore
    private String receivingUnitName;
    /**
     * 收款账号id
     */
    @ApiModelProperty("收款账号id")
    private String receivingId;

    /**
     * 收款账号
     */
    @ApiModelProperty("收款账号")
    @DbIgnore
    private String receivingNo;
    /**
     * 收款银行
     */
    @ApiModelProperty("收款银行")
    private String receivingBank;
    /**
     * 预计核销日期
     */
    @ApiModelProperty("预计核销日期")
    private LocalDate expWriteOffDate;
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司地址簿Id")
    private Long payCompanyBookId;
    /**
     * 付款公司名称
     */
    @ApiModelProperty("付款公司名称")
    @DbIgnore
    private String payCompanyName;
    /**
     * 付款银行
     */
    @ApiModelProperty("付款银行")
    private String paymentBank;
    /**
     * 付款账号
     */
    @ApiModelProperty("付款账号")
    private String paymentId;
    /**
     * 付款账号Desc
     */
    @ApiModelProperty("付款账号Desc")
    @DbIgnore
    private String paymentIdDesc;
    /**
     * 商机编号
     */
    @ApiModelProperty("商机编号")
    private String opportunity;

    /**
     * 商机名称
     */
    @ApiModelProperty("商机名称")
//    @DbField(mapTo = "prj", value = "project_name")
    @DbIgnore
    private String opportunityName;

    /**
     * 记账科目
     */
    @ApiModelProperty("记账科目")
    private Long accountingSubject;
    /**
     * 财务记账付款公司地址簿Id
     */
    @ApiModelProperty("财务记账付款公司地址簿Id")
    private Long finalPaymentCompanyBookId;
    /**
     * 财务记账付款公司名称
     */
    @ApiModelProperty("财务记账付款公司名称")
    @DbIgnore
    private String finalPaymentCompanyName;
    /**
     * 财务记账付款银行
     */
    @ApiModelProperty("财务记账付款银行")
    private String finalPaymentBank;
    /**
     * 财务记账付款账号
     */
    @ApiModelProperty("财务记账付款账号")
    private String finalPaymentId;
    @ApiModelProperty("财务记账付款账号Desc")
    @DbIgnore
    private String finalPaymentIdDesc;
    /**
     * 财务记账记账科目
     */
    @ApiModelProperty("财务记账记账科目")
    private Long finalAccountingSubject;
    @ApiModelProperty("财务记账记账科目Desc")
//    @DbField(mapTo = "acc", value = "acc_name")
    @DbIgnore
    private String finalAccountingSubjectDesc;
    /**
     * 财务记账付款方式
     */
    @ApiModelProperty("财务记账付款方式")
    private String finalPayMethod;
    @ApiModelProperty("财务记账付款方式Desc")
    @UdcName(udcName = "ACC:PAY_METHOD", codePropName = "finalPayMethod")
    @DbIgnore
    private String finalPayMethodDesc;
    /**
     * 财务记账付款日期
     */
    @ApiModelProperty("财务记账付款日期")
    private LocalDate finalPayDate;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String state;
    @ApiModelProperty("状态Desc")
    @UdcName(udcName = "purchase:payment_status", codePropName = "state")
    @DbIgnore
    private String stateDesc;
    /**
     * 流程场景
     */
    @ApiModelProperty("流程场景")
    private String scene;
    /**
     * 是否无发票核销：0：否；1：是
     */
    @ApiModelProperty("是否无发票核销：0：否；1：是")
    private Integer noInvoiceVerification;
    /**
     * 是否无单据核销：0：否；1：是
     */
    @ApiModelProperty("是否无单据核销：0：否；1：是")
    private Integer noDocVerification;
    /**
     * 预付款申请单编号
     */
    @ApiModelProperty("预付款申请单编号")
    private String prePaymentNo;
    /**
     * 预付款申请单Id
     */
    @ApiModelProperty("预付款申请单Id")
    @DbIgnore
    private Long prePaymentId;
    /**
     * 财务记账付款核销日期
     */
    @ApiModelProperty("财务记账付款核销日期")
    private LocalDate finalWriteOffDate;
    /**
     * 任务包
     */
    @ApiModelProperty("任务包")
    private Long relatedTask;
    /**
     * 实际付款日期
     */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualPayDate;
    /**
     * 判断该付款申请单是否需要上传凭证: 0：否；1：是
     */
    @ApiModelProperty("判断该付款申请单是否需要上传凭证: 0：否；1：是")
    private Integer isNeedUpload;
    /**
     * 支付标识：1.已支付 ；2.待支付
     */
    @ApiModelProperty("支付标识：1.已支付 ；2.待支付")
    private Integer payFlag;
    /**
     * 申请单事由描述
     */
    @ApiModelProperty("申请单事由描述")
    private String reasonDesc;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String accountingNote;
    /**
     * 财务记账备注
     */
    @ApiModelProperty("财务记账备注")
    private String finalAccountingNote;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 费用承担部门
     */
    @ApiModelProperty("费用承担部门")
    @DbIgnore
    private List<CostUndertakeDepartmentVO> costUndertakeDepartmentVOS;

    /** 付款明细/计划 */
    @ApiModelProperty(value = "付款明细/计划")
    @DbIgnore
    private List<PurchasePaymentPlanVO> purchasePaymentPlanVOS;

    /** 提现申请单 */
    @ApiModelProperty(value = "提现申请单")
    @DbIgnore
    private List<ResWithdrawApplyVO> resWithdrawApplyVOS;

    /** 付款单记录 */
    @ApiModelProperty(value = "付款单记录")
    @DbIgnore
    private List<PaymentSlipVO> paymentSlipVOS;

    /** 发票核销明细 */
    @ApiModelProperty(value = "发票核销明细")
    @DbIgnore
    private List<InvInvoiceVerDetailVO> invInvoiceVerDetailVOS;

    /** 票据核销明细 */
    @ApiModelProperty(value = "票据核销明细")
    @DbIgnore
    private List<BillVerDetailVO> billVerDetailPayloads;


    /** 付款参考计划 */
    @ApiModelProperty(value = "付款参考计划")
    @DbIgnore
    private List<PaymentPlanReferVO> paymentPlanReferVOS;

    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者Name
     */
    @ApiModelProperty("记录创建者Name")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    @DbIgnore
    private String createUserName;
    /**
     * 是否为紧急付款
     */
    @ApiModelProperty("是否为紧急付款")
    private Boolean urgentPaymentFlag = false;
    /**
     * 是否为驳回后再提交
     */
    @ApiModelProperty("是否为驳回后再提交")
    private Boolean isResubmit;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除标识
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    /**
     * 锁版本
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    /**
     * 收款人/单位-打印
     */
    @DbIgnore
    @ApiModelProperty(value = "收款人/单位-打印")
    private String receivingNamePrint;

    /**
     * 收款银行-打印
     */
    @DbIgnore
    @ApiModelProperty(value = "收款银行-打印")
    private String receivingBankPrint;

    @DbIgnore
    @ApiModelProperty("BU名称")
    private String buName;
    @ApiModelProperty("生成资产卡片(是/否) 0：否；1：是")
    private String assetFlag;

    @ApiModelProperty("现金流量码")
    private String flowCode;
    @DbIgnore
    @ApiModelProperty("评级")
    private String grade;
    @ApiModelProperty("JDE批次号/预付款核销凭证号")
    private String jdeVoucher;

    @ApiModelProperty("入账模块类型")
    private String accountModuleType;

    /** jde单据公司 */
    @ApiModelProperty("jde单据公司")
    private String jdeCompany;
    /** jde单据号  */
    @ApiModelProperty("jde单据号 ")
    private String jdeDocumentNo;
    /** jde单据类型 */
    @ApiModelProperty("jde单据类型")
    private String jdeDocumentType;
    /** jde付款项 */
    @ApiModelProperty("jde付款项")
    private String jdePaymentItem;

    @ApiModelProperty("jde付款号")
    private String jdePayNo;


    @ApiModelProperty("附件")
    private String fileCode;
    /**
     * 付款依据附件数据
     */
    @DbIgnore
    @ApiModelProperty("附件数据")
    private Object fileDate;


    @ApiModelProperty("是否子帐")
    private String subAccountFlag;

    /** 费用承担bu 精确 */
    @ApiModelProperty("费用承担bu")
    private String expenseBuId;

}
