package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
  * 业绩统计
  *
  * @author likunpeng
  * @date 2023-04-24
  */
@Getter
@Setter
public class ConAchieveVO extends BaseViewModel implements Serializable {
    /** 合同ID */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /** 签单额（合同含税总金额） */
    @ApiModelProperty("签单额")
    private BigDecimal amt;
    /** 有效合同金额 */
    @ApiModelProperty("有效合同金额")
    private BigDecimal effectiveAmt;
    /** 折算后有效销售额 */
    @ApiModelProperty("折算后有效销售额")
    private BigDecimal obversionEffectiveAmt;
    /** 业绩统计状态 */
    @ApiModelProperty("业绩统计状态")
    private String achieveStatus;
    @UdcName(udcName = "con:achieve:status", codePropName = "achieveStatus")
    private String achieveStatusDesc;
    private Long achieveIdV4;
    /** 业绩统计明细 */
    @ApiModelProperty("业绩统计明细")
    private List<ConAchieveDVO> conAchieveDVOS;
}
