package com.elitesland.tw.tw5.api.prd.salecon.vo;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-30
 */
@SearchBean(
        tables = "sale_con_contract scc " +
                "left join crm_opportunity co on scc.oppo_id = co.id " +
                "left join prj_project cp on co.project_id = cp.id " +
                "left join pms_project pp on pp.contract_id = scc.id " +
                "left join com_business_partner cbp on cbp.book_id = scc.ou_book_id " +
                "left join sale_con_contract scc1 on scc1.id = scc.parent_id " +
                "left join sale_con_contract scc2 on scc2.id = scc.related_contract_id " +
                "left join com_business_partner cbp1 on cbp1.book_id = scc.cust_id  " +
                "left join prd_system_fin_period pfp on pfp.id = scc.fin_period_id " +
                "left join prd_org_employee_ref poer on scc.sale_man_user_id = poer.user_id and poer.is_default=0 and poer.is_copy=0 and poer.delete_flag=0 " +
                "left join sale_con_exec_condition scec on scc.id = scec.contract_id and scec.delete_flag=0 " +
                "left join con_achieve ca on ca.contract_id = scc.id " +
                "left join con_achieve_d cad on cad.achieve_id = ca.id ",
        where = "scc.delete_flag = 0",
        groupBy = "scc.id",
        autoMapTo = "scc"
)
@Data
@ExcelIgnoreUnannotated
public class SaleConContractVO extends BaseViewModel implements Serializable {
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 提交人用户id
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    @ApiModelProperty("创建人")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    @DbIgnore
    private String createUserName;
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    @ExcelProperty(index = 0, value = "合同编号")
    private String code;
    /**
     * 合同名称
     */
    @ApiModelProperty("合同名称")
    @ExcelProperty(index = 1, value = "合同名称")
    private String name;
    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    private String status;
    @ExcelProperty(index = 2, value = "合同状态")
    @UdcName(udcName = "salecon:status", codePropName = "status")
    @DbIgnore
    private String statusDesc;
//    /**
//     * 签约公司ID
//     */
//    @ApiModelProperty("签约公司ID")
//    private Long ouId;

    @ApiModelProperty("签约公司ID")
    private Long ouBookId;

    @ApiModelProperty("签约公司名称")
    @DbField("cbp.partner_name")
    private String ouName;
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    @ExcelProperty(index = 17, value = "参考合同号")
    private String referCode;

    /**
     * 相关项目编号
     */
    @ApiModelProperty("相关项目编号")
    @ExcelProperty(index = 18, value = "相关项目编号")
    @DbField("pp.proj_no")
    private String projCode;
    @ApiModelProperty("相关项目Id")
    @DbField("pp.id")
    private Long projId;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @ExcelProperty(index = 19, value = "项目名称")
    @DbField("pp.proj_name")
    private String projName;

    /**
     * 商机ID
     */
    @ApiModelProperty("商机ID")
    private Long oppoId;
    /**
     * 商机名称
     */
    @ApiModelProperty("商机名称")
    @DbField("cp.project_name")
    private String oppoName;
    /**
     * 商机编号
     */
    @ApiModelProperty("商机编号")
    @DbField("cp.project_no")
    private String oppoNo;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 签约时客户名称
     */
    @ApiModelProperty("签约时客户名称")
    @ExcelProperty(index = 9, value = "客户名称")
    @DbField("cbp1.partner_name")
    private String custName;
    /**
     * 关联合同ID
     */
    @ApiModelProperty("关联合同ID")
    private Long relatedContractId;
    /**
     * 关联合同Code
     */
    @ApiModelProperty("关联合同Code")
    @DbField("scc2.code")
    private String relatedContractCode;
    /**
     * 关联合同名称
     */
    @ApiModelProperty("关联合同名称")
    @DbField("scc2.name")
    private String relatedContractName;
    /**
     * 新客户标志，0：新客户，1：老客户
     */
    @ApiModelProperty("新客户标志，0：新客户，1：老客户")
    private Long custFlag;
    /**
     * 签订日期
     */
    @ApiModelProperty("签订日期")
    private LocalDate signDate;
    @ExcelProperty(index = 13, value = "签单日期")
    @DbIgnore
    private String signDateStr;
    /**
     * 特别关注点
     */
    @ApiModelProperty("特别关注点")
    private String specialConcerned;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    @DbIgnore
    private String currCodeDesc;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    @UdcName(udcName = "salecon:close_cause", codePropName = "closeReason")
    @DbIgnore
    private String closeReasonDesc;
    /**
     * 客户项目
     */
    @ApiModelProperty("客户项目")
    private String custProj;
    /**
     * 销售内容
     */
    @ApiModelProperty("销售内容")
    private String saleContent;
    /**
     * 产品大类
     */
    @ApiModelProperty("产品大类")
    private String productClass;
    @ExcelProperty(index = 20, value = "产品大类")
    @UdcName(udcName = "con:sales_class", codePropName = "productClass")
    @DbIgnore
    private String productClassDesc;
    /**
     * 产品小类
     */
    @ApiModelProperty("产品小类")
    private String productSubClass;
    @DbIgnore
    private String productSubClassDesc;
    /**
     * 交付地点
     */
    @ApiModelProperty("交付地点")
    private String deliveryAddress;
    /**
     * 财务期间ID
     */
    @ApiModelProperty("财务期间ID")
    private Long finPeriodId;
    /**
     * 财务期间名称
     */
    @ApiModelProperty("财务期间名称")
    @DbField("pfp.period_name")
    private String finPeriodName;
    /**
     * 合同总金额
     */
    @ApiModelProperty("合同总金额")
    @ExcelProperty(index = 5, value = "合同金额")
    private BigDecimal amt;
    /**
     * 其它费用
     */
    @ApiModelProperty("其它费用")
    private BigDecimal extraAmt;

    /**
     * 相关项目采购
     */
    @ApiModelProperty("相关项目采购")
    @DbIgnore
    private BigDecimal demandTotalAmt;

    /**
     * 有效合同金额
     */
    @ApiModelProperty("有效合同金额")
    @ExcelProperty(index = 6, value = "有效合同金额")
    private BigDecimal effectiveAmt;
    /**
     * 不含税金額
     */
    @ApiModelProperty("不含稅金額")
    @DbIgnore
    private BigDecimal notTaxAmt;
    /**
     * 毛利
     */
    @ApiModelProperty("毛利")
    private BigDecimal grossProfit;
    /**
     * 销售区域BU_ID
     */
    @ApiModelProperty("销售区域BU_ID")
    private Long regionBuId;
    @ExcelProperty(index = 10, value = "销售区域BU")
    @UdcName(udcName = "BU", codePropName = "regionBuId")
    @DbIgnore
    private String regionBuName;
    /**
     * 销售区域负责人
     */
    @ApiModelProperty("销售区域负责人")
    private Long regionUserId;
    @UdcName(udcName = "USER", codePropName = "regionUserId")
    @DbIgnore
    private String regionUserName;
    /**
     * 签单BU_ID
     */
    @ApiModelProperty("签单BU_ID")
    private Long signBuId;
    /**
     * 签单BU名称
     */
    @ExcelProperty(index = 11, value = "签单BU")
    @UdcName(udcName = "BU", codePropName = "signBuId")
    @DbIgnore
    private String signBuName;
    /**
     * 副签单BU_ID
     */
    @ApiModelProperty("副签单BU_ID")
    private Long coSignBuId;
    /**
     * 副签单BU名称
     */
    @UdcName(udcName = "BU", codePropName = "coSignBuId")
    @DbIgnore
    private String coSignBuName;
    /**
     * 副签单用户id
     */
    @ApiModelProperty("副签单用户id")
    private Long coSignUserId;
    /**
     * 副签单用户名称
     */
    @UdcName(udcName = "USER", codePropName = "coSignUserId")
    @DbIgnore
    private String coSignUserName;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /**
     * 交付BU名称
     */
    @ExcelProperty(index = 14, value = "交付BU")
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    @DbIgnore
    private String deliBuName;
    /**
     * 交付用户id
     */
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    /**
     * 交付用户名称
     */
    @ExcelProperty(index = 15, value = "交付负责人")
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    @DbIgnore
    private String deliUserName;
    /**
     * 副交付BU_ID
     */
    @ApiModelProperty("副交付BU_ID")
    private Long codeliBuId;
    /**
     * 副交付BU名称
     */
    @UdcName(udcName = "BU", codePropName = "codeliBuId")
    @DbIgnore
    private String codeliBuName;
    /**
     * 副交付用户id
     */
    @ApiModelProperty("副交付用户id")
    private Long codeliUserId;
    /**
     * 副交付用户
     */
    @UdcName(udcName = "USER", codePropName = "codeliUserId")
    @DbIgnore
    private String codeliUserName;
    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    private String platType;
    @ExcelProperty(index = 3, value = "平台合同类型")
    @UdcName(udcName = "salecon:plat_type", codePropName = "platType")
    @DbIgnore
    private String platTypeDesc;
    /**
     * 合同类型
     */
    @ApiModelProperty("合同类型")
    private String mainType;
    @ExcelProperty(index = 4, value = "合同类型")
    @UdcName(udcName = "salecon:mainType", codePropName = "mainType")
    @DbIgnore
    private String mainTypeDesc;
    /**
     * PMO用户ID
     */
    @ApiModelProperty("PMO用户ID")
    private Long pmoUserId;
    /**
     * PMO用户名称
     */
    @ExcelProperty(index = 16, value = "PMO")
    @UdcName(udcName = "USER", codePropName = "pmoUserId")
    @DbIgnore
    private String pmoUserName;
    /**
     * 来源类型
     */
    @ApiModelProperty("来源类型")
    private String sourceType;
    /**
     * 来源类型
     */
    @UdcName(udcName = "salecon:source_type", codePropName = "sourceType")
    @ExcelProperty(index = 25, value = "合同来源")
    @DbIgnore
    private String sourceTypeDesc;
    /**
     * 外部来源
     */
    @ApiModelProperty("外部来源")
    private String externalIden;
    /**
     * 外部来源人
     */
    @ApiModelProperty("外部来源人")
    private String externalName;
    /**
     * 外部来源电话
     */
    @ApiModelProperty("外部来源电话")
    private String externalPhone;
    /**
     * 内部来源BU_ID
     */
    @ApiModelProperty("内部来源BU_ID")
    private Long internalBuId;
    @UdcName(udcName = "BU", codePropName = "internalBuId")
    @DbIgnore
    private String internalBuName;
    /**
     * 利益承诺
     */
    @ApiModelProperty("利益承诺")
    @ExcelProperty(index = 23, value = "利益承诺")
    private String profitDesc;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "taxRate")
    @DbIgnore
    private String taxRateDesc;
    /**
     * 销售负责人ID
     */
    @ApiModelProperty("销售负责人ID")
    private Long saleManUserId;
    /**
     * 销售负责人名称
     */
    @ExcelProperty(index = 12, value = "销售负责人")
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    @DbIgnore
    private String saleManUserName;

    /**
     * 销售负责人BU
     */
    @ApiModelProperty("销售负责人BU")
    @DbField("poer.org_id")
    private Long saleManUserBuId;
    /**
     * 内部来源用户ID
     */
    @ApiModelProperty("内部来源用户ID")
    private Long internalUserId;
    /**
     * 内部来源用户
     */
    @UdcName(udcName = "USER", codePropName = "internalUserId")
    @DbIgnore
    private String internalUserName;
    /**
     * 合同开始日期
     */
    @ApiModelProperty("合同开始日期")
    private LocalDate startDate;
    /**
     * 合同结束日期
     */
    @ApiModelProperty("合同结束日期")
    private LocalDate endDate;

    /**
     * 合同开始日期
     */
    @ApiModelProperty("合同开始日期")
    @ExcelProperty(index = 27, value = "合同开始日期")
    @DbIgnore
    private String startDateStr;
    /**
     * 合同结束日期
     */
    @ApiModelProperty("合同结束日期")
    @ExcelProperty(index = 28, value = "合同结束日期")
    @DbIgnore
    private String endDateStr;


    /**
     * 纸质合同状态描述
     */
    @ApiModelProperty("纸质合同状态描述")
    private String paperDesc;
    /**
     * 纸质合同状态
     */
    @ApiModelProperty("纸质合同状态")
    private String paperStatus;
    @ExcelProperty(index = 21, value = "纸质合同状态")
    @UdcName(udcName = "salecon:paper_status", codePropName = "paperStatus")
    @DbIgnore
    private String paperStatusDesc;
    /**
     * 合同激活时间
     */
    @ApiModelProperty("合同激活时间")
    private LocalDate acitveDate;
    /**
     * 产品
     */
    @ApiModelProperty("产品")
    private Long product;
    /**
     * 简要说明
     */
    @ApiModelProperty("简要说明")
    private String briefDesc;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    @DbIgnore
    private String workTypeDesc;
    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;
    @UdcName(udcName = "salecon:promotional_code", codePropName = "promotionType")
    @DbIgnore
    private String promotionTypeDesc;
    /**
     * 范围性质
     */
    @ApiModelProperty("范围性质")
    private String rangeProp;
    @UdcName(udcName = "salecon:range_property", codePropName = "rangeProp")
    @DbIgnore
    private String rangePropDesc;
    /**
     * 半开口说明
     */
    @ApiModelProperty("半开口说明")
    private String halfOpenDesc;
    /**
     * 供应主体类别
     */
    @ApiModelProperty("供应主体类别")
    private String supplierType;
    @UdcName(udcName = "salecon:supplier", codePropName = "supplierType")
    @DbIgnore
    private String supplierTypeDesc;
    /**
     * 提成类别
     */
    @ApiModelProperty("提成类别")
    private String commissionType;
    @UdcName(udcName = "salecon:project_type", codePropName = "commissionType")
    @DbIgnore
    private String commissionTypeDesc;
    /**
     * 交易方式
     */
    @ApiModelProperty("交易方式")
    private String transactionMethod;
    @UdcName(udcName = "salecon:trading_method", codePropName = "transactionMethod")
    @DbIgnore
    private String transactionMethodDesc;
    /**
     * 交易性质
     */
    @ApiModelProperty("交易性质")
    private String transactionNature;
    @UdcName(udcName = "salecon:trade_quality", codePropName = "transactionNature")
    @DbIgnore
    private String transactionNatureDesc;
    /**
     * 需求类别
     */
    @ApiModelProperty("需求类别")
    private String demandType;
    @UdcName(udcName = "salecon:demand_type", codePropName = "demandType")
    @DbIgnore
    private String demandTypeDesc;
    /**
     * 销售分类
     */
    @ApiModelProperty("销售分类")
    private String saleClass;
    @UdcName(udcName = "salecon:sales_type", codePropName = "saleClass")
    @DbIgnore
    private String saleClassDesc;
    /**
     * 客户承担差旅费
     */
    @ApiModelProperty("客户承担差旅费")
    private String custBarExpense;
    @UdcName(udcName = "salecon:cust_bear", codePropName = "saleClass")
    @DbIgnore
    private String custBarExpenseDesc;
    /**
     * 报销政策说明
     */
    @ApiModelProperty("报销政策说明")
    private String reimbursementDesc;
    /**
     * 估算当量
     */
    @ApiModelProperty("估算当量")
    private BigDecimal ratedEqva;
    /**
     * 估算费用
     */
    @ApiModelProperty("估算费用")
    private BigDecimal ratedExpense;
    /**
     * 合同打印方
     */
    @ApiModelProperty("合同打印方")
    private String contractPrinter;
    @UdcName(udcName = "salecon:printed_by", codePropName = "contractPrinter")
    @DbIgnore
    private String contractPrinterDesc;
    /**
     * 打印份数
     */
    @ApiModelProperty("打印份数")
    private Long printCount;
    /**
     * 盖章类型
     */
    @ApiModelProperty("盖章类型")
    private String sealType;
    @UdcName(udcName = "salecon:stamp_type", codePropName = "sealType")
    @DbIgnore
    private String sealTypeDesc;
    /**
     * 和发票一起邮寄，0：是，1：否
     */
    @ApiModelProperty("和发票一起邮寄，0：是，1：否")
    private Integer sendWithInvoiceFlag;
    /**
     * 邮寄地址
     */
    @ApiModelProperty("邮寄地址")
    private String mailingAddress;
    /**
     * 父ID
     */
    @ApiModelProperty("主合同ID")
    private Long parentId;

    @ApiModelProperty("易道壳的文件夹id")
    private String folderId;

    @ApiModelProperty("主合同易道壳的文件夹id")
    @DbField("scc1.folder_id")
    private String parentFolderId;
    /**
     * 主合同名称
     */
    @ApiModelProperty("主合同名称")
    @DbField("scc1.name")
    private String parentName;

    /**
     * 创建人名称
     */
//    @ApiModelProperty("创建人名称")
//    @UdcName(udcName = "USER", codePropName = "createUserId")
//    private String createUserName;

    /**
     * 关闭时间
     */
    @ApiModelProperty("关闭时间")
    private LocalDate closeDate;

    /**
     * 售前bu
     */
    @ApiModelProperty("售前bu")
    private Long preSaleBuId;
    /**
     * 售前bu
     */
    @ApiModelProperty("售前bu")
    @UdcName(udcName = "BU", codePropName = "preSaleBuId")
    @DbIgnore
    private String preSaleBuName;

    /**
     * 售前负责人
     */
    @ApiModelProperty("售前负责人")
    private Long preSaleUserId;
    /**
     * 售前负责人
     */
    @ApiModelProperty("售前负责人")
    @UdcName(udcName = "USER", codePropName = "preSaleUserId")
    @DbIgnore
    private String preSaleUserName;
    /**
     * 开票金额
     */
    @ApiModelProperty("开票金额")
    @ExcelProperty(index = 7, value = "开票金额")
    @DbIgnore
    private BigDecimal invoicingAmount;
    /**
     * 收款金额
     */
    @ApiModelProperty("收款金额")
    @ExcelProperty(index = 8, value = "收款金额")
    @DbIgnore
    private BigDecimal amountCollected;

    /**
     * 合同附件
     */
    @ApiModelProperty("合同附件")
    private String fileCodes;

    /**
     * 合同附件数据
     */
    @ApiModelProperty("合同附件数据")
    @DbIgnore
    private Object fileDatas;

    /**
     * sow附件
     */
    @ApiModelProperty("sow附件")
    private String sowFileCodes;

    /**
     * sow附件数据
     */
    @ApiModelProperty("sow附件数据")
    @DbIgnore
    private Object sowDatas;

    /**
     * 估算申请单附件
     */
    @ApiModelProperty("估算申请单附件")
    private String assessFileCodes;

    /**
     * 算申请单附件数据
     */
    @ApiModelProperty("算申请单附件数据")
    @DbIgnore
    private Object assessDatas;

    /**
     * 合同关闭附件
     */
    @ApiModelProperty("合同关闭附件")
    private String closeFileCodes;

    /**
     * 算申请单附件数据
     */
    @ApiModelProperty("合同关闭附件数据")
    @DbIgnore
    private Object closeDatas;

    /**
     * 业绩统计状态
     */
    @ApiModelProperty("业绩统计状态")
    @DbField("ca.achieve_status")
    private String achieveStatus;
    @UdcName(udcName = "con:achieve:status", codePropName = "achieveStatus")
    @ExcelProperty(index = 24, value = "业绩统计状态")
    @DbIgnore
    private String achieveStatusDesc;


    @ApiModelProperty("记录创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    @ExcelProperty(index = 22, value = "记录创建时间")
    @DbIgnore
    private String createTimeStr;

    /**
     * 合同归档标志 0：未归档,1:归档
     */
    @ApiModelProperty("合同归档标志")
    private Integer filingFlag;

    @ExcelProperty(index = 26, value = "是否归档")
    @DbIgnore
    private String filingFlagDesc;

    public String getFilingFlagDesc() {
        if (this.filingFlag == 0) {
            return "否";
        } else {
            return "是";
        }
    }

//    /**
//     * 其他应减费用（外包总费用）
//     */
//    @ApiModelProperty("其他应减费用（外包总费用）")
//    private BigDecimal costTotalAmt;

    /**
     * 财务核算毛利率
     */
    @ApiModelProperty("财务核算毛利率")
    private BigDecimal finGross;

    /**
     * 财务核定额定当量
     */
    @ApiModelProperty("财务核定额定当量")
    private BigDecimal finRatedEqva;

    /**
     * 系统核算毛利率
     */
    @ApiModelProperty("系统核算毛利率")
    private BigDecimal sysGross;

    @ApiModelProperty("净Rate")
    private BigDecimal netRate;

    @ApiModelProperty("额定费用")
    private BigDecimal ratedCost;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /**
     * 合同预算权限
     */
    @ApiModelProperty("合同预算权限")
    @DbIgnore
    private Boolean saleBudgetAuthFlag;

    /**
     * 变更中标志 0:否 1:是
     */
    @ApiModelProperty("变更中标志 0:否 1:是")
    @DbIgnore
    private Integer changeFlag;

    /**
     * 是否审批完成 子合同变更使用
     */
    @ApiModelProperty("是否审批完成")
    @DbIgnore
    private Boolean approveFlag = false;

    /**
     * jde客户编号
     */
    @ApiModelProperty("jde客户编号")
    @DbIgnore
    private String customerNo;

    public String getCreateTimeStr() {
        return ObjectUtils.isEmpty(this.createTime) ? null : LocalDateTimeUtil.format(this.createTime, DatePattern.NORM_DATETIME_PATTERN);
    }

    public String getSignDateStr() {
        return ObjectUtils.isEmpty(this.signDate) ? null : this.signDate.toString();
    }

    /**
     * 客户状态
     */
    @ApiModelProperty("客户状态")
    @DbIgnore
    private String custStatus;


    /**
     * 业务伙伴id
     */
    @ApiModelProperty("业务伙伴id")
    @DbIgnore
    private Long partnerId;

    @ApiModelProperty("jde同步状态")
    private String jdeStatus;

    @ApiModelProperty("jde同步状态")
    @UdcName(udcName = "JDE:JDE_STATUS", codePropName = "jdeStatus")
    @DbIgnore
    private String jdeStatusDesc;

    @ApiModelProperty("jde失败原因")
    private String jdeFailReason;

    @ApiModelProperty("合同收回时间")
    private LocalDateTime receiveTime;

    /*************** 冗余字段，用与查询***********////

    @ApiModelProperty("scecContractId")
    @DbField("scec.contract_id")
    private Long scecContractId;
    @ApiModelProperty("valueRole")
    @DbField("cad.value_role")
    private String valueRole;
    @ApiModelProperty("chargeResId")
    @DbField("cad.charge_res_id ")
    private Long chargeResId;
    @ApiModelProperty("achieveBuId")
    @DbField("cad.bu_id")
    private Long achieveBuId;
    @ApiModelProperty("caId")
    @DbField("ca.id")
    private Long caId;

}
