package com.elitesland.tw.tw5.api.prd.task.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
@Getter
@Setter
public class TaskSettleTimesheetPayload extends TwCommonPayload implements Serializable {
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    /**
     * 结算id
     */
    @ApiModelProperty("结算id")
    private Long settleId;
    /**
     * 工时id
     */
    @ApiModelProperty("工时id")
    private Long timesheetId;
    /**
     * 工时
     */
    @ApiModelProperty("工时")
    private BigDecimal workHour;
    /**
     * 当量
     */
    @ApiModelProperty("当量")
    private BigDecimal eqva;
    /**
     * 工作日期
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工作日志
     */
    @ApiModelProperty("工作日志")
    private String workDesc;
    /**
     * 工时任务结算流转标记（后改的，结构不好动所以命名和值定义不太合理）：-1或null已提交，0已审批，1已结算
     */
    @ApiModelProperty("工时任务结算流转标记（后改的，结构不好动所以命名和值定义不太合理）：-1或null已提交，0已审批，1已结算")
    private Integer settleFlag;
}
