package com.elitesland.tw.tw5.api.common.change.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

/**
 * 通用变更信息表(com_business_change)实体类
 *
 * @author liwenpeng
 */

@Data
public class PrdSystemBusinessChangePayload extends TwCommonPayload {
    private static final long serialVersionUID = 1L;


    /**
     * 变更类型
     */
    private String changeType;

    /**
     * 变更单据id
     */
    private String changeDocId;

    /**
     * 父级变更单据类型
     */
    private String parentChangeType;

    /**
     * 父级变更单据id
     */
    private String parentChangeDocId;


    /**
     * 变更信息
     */
    private String changeContent;

    /**
     * 当前版本信息
     */
    private String versionContent;


    /**
     * 版本
     */
    private Integer versionNo;


    /**
     * 版本状态 1:已完成   0:草稿
     */
    private Integer versionStatus;

    /**
     * 流程实例ID
     */
    private String procInstId;

}

