package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 科目模板管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccSubjectTemplatePayload extends TwCommonPayload implements Serializable {
    /**
     * 模板编号
     */
    @ApiModelProperty("模板编号")
    private String tmplNo;
    /**
     * 模板名称
     */
    @ApiModelProperty("模板名称")
    private String tmplName;
    /**
     * 适用行业
     */
    @ApiModelProperty("适用行业")
    private String tmplIndustry;
    /**
     * 模板状态
     */
    @ApiModelProperty("模板状态")
    private String tmplStatus;
    /**
     * 模板类别
     */
    @ApiModelProperty("模板类别")
    private String tmplClass;
    /**
     * 适用类型
     */
    @ApiModelProperty("适用类型")
    private String tmplType;
    /**
     * 预算控制级别
     */
    @ApiModelProperty("预算控制级别")
    private Integer budgetLevel;
    /**
     * 控制策略
     */
    @ApiModelProperty("控制策略")
    private String controlType;
    /**
     * 可配置字段1
     */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /**
     * 可配置字段2
     */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /**
     * 可配置字段3
     */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /**
     * 可配置字段4
     */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /**
     * 可配置字段5
     */
    @ApiModelProperty("可配置字段5")
    private String extStr5;
    /**
     * 科目明细数据
     */
    @ApiModelProperty("科目明细数据")
    private List<AccSubjectTemplateDetailPayload> tmpldPayloads;
}
