package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;

import java.util.List;

/**
 * 科目模板明细管理
 *
 * @author carl
 * @date 2023-09-25
 */
public interface AccSubjectTemplateDetailService {
    /**
     * 新增
     *
     * @param payloads 单据数据
     * @return {@link AccSubjectTemplateDetailVO}
     */
    List<AccSubjectTemplateDetailVO> bacthInsert(List<AccSubjectTemplateDetailPayload> payloads, AccSubjectTemplateVO accSubjectTemplateVO);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据模板id逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoftByTemlIds(List<Long> keys);

    /**
     * 分页查询明细
     *
     * @param query
     * @return
     */
    PagingVO<AccSubjectTemplateDetailVO> queryPaging(AccSubjectTemplateDetailQuery query);

    /**
     * 根据模板id查询明细列表
     *
     * @param tmplId
     * @return
     */
    List<AccSubjectTemplateDetailVO> queryListByTmplId(Long tmplId);

    /**
     * 根据模板id查询模板关联的预算项目数据
     *
     * @param tmplId
     * @return
     */
    List<AccBudgetItemVO> queryBudgetItemList(Long tmplId);
    //    /**
//     * 分页列表
//     *
//     * @param query 条件
//     * @return {@link PagingVO}<{@link AccSubjectTemplateDetailVO}>
//     */
//    PagingVO<AccSubjectTemplateDetailVO> queryPaging(AccSubjectTemplateDetailQuery query);
//
//    /**
//     * 查询列表
//     *
//     * @param query 条件参数
//     * @return {@link List}<{@link AccSubjectTemplateDetailVO}>
//     */
//    List<AccSubjectTemplateDetailVO> queryListDynamic(AccSubjectTemplateDetailQuery query);
//
//    /**
//     * 通过主键查询
//     *
//     * @param key 主键
//     * @return {@link AccSubjectTemplateDetailVO}
//     */
//    AccSubjectTemplateDetailVO queryByKey(Long key);
//
//    /**
//     * 新增
//     *
//     * @param payload 单据数据
//     * @return {@link AccSubjectTemplateDetailVO}
//     */
//    AccSubjectTemplateDetailVO insert(AccSubjectTemplateDetailPayload payload);
//
//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link AccSubjectTemplateDetailVO}
//     */
//    AccSubjectTemplateDetailVO update(AccSubjectTemplateDetailPayload payload);
//
//    /**
//     * 修改,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 单据数据
//     * @return {@link long}
//     */
//    long updateByKeyDynamic(AccSubjectTemplateDetailPayload payload);
//
//    /**
//     * 逻辑删除
//     *
//     * @param keys 主键集合
//     */
//    void deleteSoft(List<Long> keys);

}
