package com.elitesland.tw.tw5.api.prd.budget.service;

import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 预算公共 接口
 */
public interface BudgetCommonService {


    /**
     * 初始化预算
     *
     * @param sourceId
     * @param sourceType
     */
    BudgetVO initBudget(Long sourceId, String sourceType);

    /**
     * 通过 资源 查询预算
     *
     * @param sourceId
     * @param sourceType
     * @return
     */
    BudgetVO querySimpleBySource(Long sourceId, String sourceType);


    /////////////////////////////////////////////////////////////////////

    /**
     * 获取 项目、合同 相关信息
     *
     * @param budgetVO
     */
    void addProjectInfo(BudgetVO budgetVO);


    /**
     * 获取 累计收款比例
     *
     * @param saleConId
     * @return
     */
    BigDecimal getReceivedRate(Long saleConId);

//    /**
//     * 获取累计拨付比例
//     *
//     * @return
//     */
//    BigDecimal getAllocatedProportion(Long budgetId);
//
//    /**
//     * 获取拨付相关信息
//     *
//     * @return
//     */
//    void getAppropriationInfo(BudgetVO budgetVO);
//
//    /**
//     * 更新预算相关拨付信息
//     *
//     * @param budgetId
//     */
//    void updateAppropriationInfo(Long budgetId);

//    /**
//     * 获取当量相关信息  由于 表里已经有了相关字段 ，不需要 现算
//     *
//     * @param budgetVO
//     * @return
//     */
//    void getEqvaInfoFromTask(BudgetVO budgetVO);

//    /**
//     * 获取费用相关信息  由于 表里已经有了相关字段 ，不需要 现算
//     *
//     * @param budgetVO
//     * @return
//     */
//    void getAmtUsedInfo(BudgetVO budgetVO);

//    /**
//     * 更新拨付相关状态
//     */
//    void updateStatus(Long budgetId, Long appropriationId, ProcessInfo processInfo);

//    /**
//     * 根据预算id 查出拨付信息
//     *
//     * @param budgetId
//     * @return
//     */
//    BudgetAppropriationVO getAppropriationInfo(Long budgetId);

//    /**
//     * 预算相关流程审批完成后，涉及到知会财务相关人员的，在TW5.0里放到消息通知-业务提醒中
//     *
//     * @param objectId
//     * @param messageTitle
//     */
//    void messNotice(Long objectId, String messageTitle);

    /**
     * 确认当前是否是只有一个流程
     */
    void checkOnlyOneProc(BudgetVO budgetVO);

//    /**
//     * 获取 验证参数
//     *
//     * @param budgetId
//     * @param contractId
//     * @return
//     */
//    Map<String, Object> getCheckParam(BudgetAppropriationPayload payload, Long budgetId, Long contractId);

    /**
     * 判断是否为内部项目
     *
     * @param platType
     * @return
     */
    Boolean isInnerProject(String platType);

//    /**
//     * 判断是否为外部项目
//     *
//     * @param platType
//     * @return
//     */
//    Boolean isOuterProject(String platType);

    /***
     * 判断是否为外部项目
     * @param platType
     * @return
     */
    Boolean isExternalProject(String platType);

    /**
     * 外部有合同项目:平台合同类型=平台内，平台外，提前入场虚拟合同&&子合同状态=激活
     *
     * @param platType
     * @param contractStatus
     * @return
     */
    Boolean isExternalContractProject(String platType, String contractStatus);

    /**
     * 外部无合同提前入场:平台合同类型=提前入场虚拟合同，且子合同状态=待激活
     *
     * @param platType
     * @param contractStatus
     * @return
     */
    Boolean isExternalNoContractProject(String platType, String contractStatus);

//    /**
//     * 计算金额相关
//     *
//     * @param budgetVO
//     */
//    void countAmt(BudgetVO budgetVO);

    /***
     * 累计变更 相关
     * @param budgetVO
     */
    void countTotalChange(BudgetVO budgetVO);

    /**
     * 累计变更 相关
     *
     * @param currentVersionBudge 当前变更版本预算
     */
    void countCurrentChange(BudgetVO currentVersionBudge);


    /**
     * 任务申请时,验证当量是否超出预算
     *
     * @param reasonId
     * @param reasonType
     * @param eqva
     */
    void checkBudgetEqva(Long reasonId, String reasonType, Long relatedActId, BigDecimal eqva);
    /**
     * 校验报销费用
     *
     * @param reasonId
     * @param reasonType
     * @param eqva
     */
    /**
     * 校验报销费用
     *
     * @param reasonId     事由id
     * @param reasonType   事由类型
     * @param budgetItemId 预算项目id
     * @param amt          报销金额
     */
    void checkBudgetAmt(Long reasonId, String reasonType, Long budgetItemId, BigDecimal amt, Long... reimId);

    /**
     * 根据科目模板id查找预算科目
     *
     * @param subjectTemplateId
     * @return
     */
    List<BudgetSubjectDetailVO> queryBySubjectTemplateId(String sourceType, Long subjectTemplateId);

    /**
     * 查询单个事由和事由类型预算当量、费用使用及占用情况
     *
     * @param reasonType
     * @param reasonId
     * @return
     */
    BudgetCommonVO queryBudgetEqvaAndAmt(String reasonType, Long reasonId);

    /**
     * 查询多个事由和事由类型预算当量、费用使用及占用情况
     *
     * @param reasonTypes
     * @param reasonIds
     * @return
     */
    List<BudgetCommonVO> queryBudgetEqvaAndAmts(List<String> reasonTypes, List<Long> reasonIds);

    /**
     * 获取当量使用和占用情况
     * 对外暴露的原因是工时审批配置要根据占用比例计算审批人
     *
     * @param commonVO
     * @param taskInfoVOS
     */
    void queryBudgetEqva(BudgetCommonVO commonVO, List<TaskInfoVO> taskInfoVOS);
}
