package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomeLogPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeLogQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeLogVO;

import java.util.List;

/**
 * 当量收入配置变更记录
 *
 * @author wangly
 * @date 2024-02-22
 */
public interface CalEqvaIncomeLogService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalEqvaIncomeLogVO}>
     */
    PagingVO<CalEqvaIncomeLogVO> queryPaging(CalEqvaIncomeLogQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalEqvaIncomeLogVO}>
     */
    List<CalEqvaIncomeLogVO> queryListDynamic(CalEqvaIncomeLogQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalEqvaIncomeLogVO}
     */
    CalEqvaIncomeLogVO queryByKey(Long key);

    /**
     * 查询最近的一条记录
     *
     * @param key 当量收入配置表主键
     * @return {@link CalEqvaIncomeLogVO}
     */
    CalEqvaIncomeLogVO queryFirstByRelateId(Long key);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CalEqvaIncomeLogVO}
     */
    CalEqvaIncomeLogVO insert(CalEqvaIncomeLogPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CalEqvaIncomeLogVO}
     */
    CalEqvaIncomeLogVO update(CalEqvaIncomeLogPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CalEqvaIncomeLogPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);



}
