package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 礼品单
 *
 * @author xxb
 * @date 2023-08-31
 */
@Getter
@Setter
public class CrmGiftListQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 礼品单编号 精确 */
    @ApiModelProperty("礼品单编号")
    private String giftNo;
    @ApiModelProperty("申请人")
    private Long applyUserId;
    /** 申请人bu 精确 */
    @ApiModelProperty("申请人bu")
    private Long applyUserBuId;
    @ApiModelProperty("创建人bu")
    private Long createUserBuId;
    /** 礼品类型 一级 精确 */
    @ApiModelProperty("礼品类型 一级")
    private String giftType1;
    /** 礼品类型 二级 精确 */
    @ApiModelProperty("礼品类型 二级")
    private String giftType2;
    /** 特殊申请用户标志 精确 */
    @ApiModelProperty("特殊申请用户标志")
    private Integer specialUsersFlag;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /** 申请日期 */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;
    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;

    @ApiModelProperty("申请人")
    private List<Long> userIds;

    /** 客户名称 精确 */
    @ApiModelProperty("客户名称")
    private String custName;


    @ApiModelProperty("礼品详情id集合")
    private Long[] keys;

    /** 客户方 */
    @ApiModelProperty("客户方")
    private Long customerId;


}
