package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author zoey
 * @Description:线索跟进表
 * @date 2022/5/17 - 11:39
 */
@Data
public class CrmFollowVO extends BaseViewModel {


    /**
     * 往来对象
     */
    @ApiModelProperty("往来对象")
    private String followObject;

    /**
     * 往来对象名称
     */
    @ApiModelProperty("往来对象名称")
    private String followObjectDesc;


    /**
     * 对象id
     */
    @ApiModelProperty("对象id")
    private Long objectId;

    /**
     * 往来类型
     */
    @ApiModelProperty("往来类型")
    private String followType;

    /**
     * 往来类型名称
     */
    @ApiModelProperty("往来类型名称")
    private String followTypeDesc;

    /**
     * 往来内容
     */
    @ApiModelProperty("往来内容")
    private String followContent;

    /**
     * 附件地址
     */
    @ApiModelProperty("附件地址")
    private String fileCodes;

    /**
     * 文件数据
     */
    @ApiModelProperty("文件数据")
    private Object fileDatas;



    /** 拜访成员姓名 */
    @ApiModelProperty("拜访成员姓名")
    private String visitMemberName;

    /** 协防人员 多个英文逗号隔开 */
    @ApiModelProperty("协防人员 多个英文逗号隔开")
    private String teamMemberNames;


    /** 关联信息 */
    @ApiModelProperty("关联信息")
    private String relationContent;
    /** 关联信息主键（关联主键) */

    @ApiModelProperty("关联信息主键（关联主键)")
    private Long relationId;

    /** 客户情况说明 */
    @ApiModelProperty("客户情况说明")
    private String customerDesc;

    /** 拜访进展与结果 */
    @ApiModelProperty("拜访进展与结果")
    private String result;

    /** 下次拜访时间 */
    @ApiModelProperty("下次拜访时间")
    private LocalDateTime nextVisitTime;
//    /**
//     * 线索id
//     */
//    @JsonSerialize(
//            using = ToStringSerializer.class
//    )
//    private Long leadsId;
//
//    /**
//     * 商机id
//     */
//    @JsonSerialize(
//            using = ToStringSerializer.class
//    )
//    private Long opportunityId;
//
////    /**
////     * 项目id
////     */
////    private Long projectId;
//
//
//    /**
//     * 潜在客户id
//     */
//    @JsonSerialize(
//            using = ToStringSerializer.class
//    )
//    private Long potentialCustomerId;
//
//    /**
//     * 客户id
//     */
//    @JsonSerialize(
//            using = ToStringSerializer.class
//    )
//    private Long customerId;
//
//    /**
//     * 联系人id
//     */
//    @JsonSerialize(
//            using = ToStringSerializer.class
//    )
//    private Long contactsId;
//
//
    /**
     * 创建人
     */
    private String createUserName;

}
