package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamPointVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核点Service
 */
 
public interface PrdPerformanceExamPointService {
    
    /**
     * 新增绩效考核点数据
     * @param prdPerformanceExamPointPayload
     * @return
     */
    PrdPerformanceExamPointVO save(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload);
    
     /**
     * 根据主键更新
     * @param prdPerformanceExamPointPayload
     * @return
     */
    PrdPerformanceExamPointVO update(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdPerformanceExamPointVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdPerformanceExamPointQuery
     * @return
     */
    PagingVO<PrdPerformanceExamPointVO> page(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdPerformanceExamPointQuery
      * @return
      */
     List<PrdPerformanceExamPointVO> getList(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery);
    
        /**
      * 根据条件修改
      * @param prdPerformanceExamPointPayload
      * @return
      */
     Long updateByCondition(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload);

     /**
      * 根据绩效id删除
      * @param id
      * @return
      */
     Long delByExamId(Long id);
 }

