package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核Service
 */
 
public interface PrdPerformanceExamService {
    
    /**
     * 新增绩效考核数据
     * @param prdPerformanceExamPayload
     * @return
     */
    PrdPerformanceExamVO save(PrdPerformanceExamPayload prdPerformanceExamPayload);
    
     /**
     * 根据主键更新
     * @param prdPerformanceExamPayload
     * @return
     */
    PrdPerformanceExamVO update(PrdPerformanceExamPayload prdPerformanceExamPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdPerformanceExamVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdPerformanceExamQuery
     * @return
     */
    PagingVO<PrdPerformanceExamVO> page(PrdPerformanceExamQuery prdPerformanceExamQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdPerformanceExamQuery
      * @return
      */
     List<PrdPerformanceExamVO> getList(PrdPerformanceExamQuery prdPerformanceExamQuery);
    
        /**
      * 根据条件修改
      * @param prdPerformanceExamPayload
      * @return
      */
     Long updateByCondition(PrdPerformanceExamPayload prdPerformanceExamPayload);

     /**
      * 发起绩效考核
      * @param prdPerformanceExamPayload
      * @return
      */
     Long startflow(PrdPerformanceExamPayload prdPerformanceExamPayload);

 }

