package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

import io.swagger.annotations.ApiModel;
import com.elitescloud.boot.common.param.BaseViewModel;


/**
 * @author : WWW
 * @date : 2023-11-3
 * @desc : baseBu变更
 */

@Data
@ApiModel(description = "baseBu变更")
public class PrdBaseBuChangeVO extends BaseViewModel {

    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long userId;

    /**
     * 员工id
     */
    @ApiModelProperty("员工id")
    private Long empId;

    /**
     * 员工名称
     */
    @ApiModelProperty("员工名称")
    private String empName;

    /**
     * 原上级id
     */
    @ApiModelProperty("原上级id")
    private Long oldPEmpId;

    /**
     * 原上级用户Id
     */
    @ApiModelProperty("原上级用户Id")
    private Long oldPUserId;

    /**
     * 原上级名称
     */
    @ApiModelProperty("原上级名称")
    private String oldPEmpName;

    /**
     * 新上级id
     */
    @ApiModelProperty("新上级id")
    private Long newPEmpId;

    /**
     * 新上级用户Id
     */
    @ApiModelProperty("新上级用户Id")
    private Long newPUserId;

    /**
     * 新上级名称
     */
    @ApiModelProperty("新上级名称")
    private String newPEmpName;

    /**
     * 主能力
     */
    @ApiModelProperty("主能力")
    private String mainAbility;

    /**
     * 次能力
     */
    @ApiModelProperty("次能力")
    private String auxAbility;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal dlRatio;

    /**
     * 入职日期
     */
    @ApiModelProperty("入职日期")
    private LocalDate entryDate;

    /**
     * 原加入日期
     */
    @ApiModelProperty("原加入日期")
    private LocalDate oldJoinDate;

    /**
     * 新加入日期
     */
    @ApiModelProperty("新加入日期")
    private LocalDate newJoinDate;

    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String cooperateType;

    /**
     * 职级
     */
    @ApiModelProperty("职级")
    private String jobGrade;

    /**
     * 职级生效日期
     */
    @ApiModelProperty("职级生效日期")
    private LocalDate jobGradeActiveDate;

    /**
     * 发薪方式
     */
    @ApiModelProperty("发薪方式")
    private String salaryType;

    /**
     * 发薪周期
     */
    @ApiModelProperty("发薪周期")
    private String salaryCycle;

    /**
     * 原buId
     */
    @ApiModelProperty("原buId")
    private Long oldBuId;

    /**
     * 原bu名称
     */
    @ApiModelProperty("原bu名称")
    private String oldBuName;

    /**
     * 新buid
     */
    @ApiModelProperty("新buid")
    private Long newBuId;

    /**
     * 新bu名称
     */
    @ApiModelProperty("新bu名称")
    private String newBuName;

    /**
     * 原角色id
     */
    @ApiModelProperty("原角色id")
    private Long oldRoleId;

    /**
     * 原角色编码
     */
    @ApiModelProperty("原角色编码")
    private String oldRoleCode;

    /**
     * 原角色名称
     */
    @ApiModelProperty("原角色名称")
    private String oldRoleName;

    /**
     * 新角色id
     */
    @ApiModelProperty("新角色id")
    private String newRoleId;

    /**
     * 新角色编码
     */
    @ApiModelProperty("新角色编码")
    private String newRoleCode;

    /**
     * 新角色名称
     */
    @ApiModelProperty("新角色名称")
    private String newRoleName;

    /**
     * 变更说明
     */
    @ApiModelProperty("变更说明")
    private String changeDesc;

    /**
     * 申请人id
     */
    @ApiModelProperty("申请人id")
    private Long applyUserId;

    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private String applyUserName;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /**
     * 原当量系数
     */
    @ApiModelProperty("原当量系数")
    private BigDecimal oldDlRatio;

    /**
     * 待办事项
     */
    @ApiModelProperty("待办事项")
    private List<PrdBuChangeTodoVO> prdBuChangeTodoVOList;

}

